/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.log;

import com.jcabi.log.Logger;
import java.util.concurrent.Callable;

public final class VerboseRunnable
implements Runnable {
    private final transient Runnable origin;
    private final transient boolean swallow;

    public VerboseRunnable(Runnable runnable) {
        this(runnable, false);
    }

    public VerboseRunnable(Runnable runnable, boolean swlw) {
        this.origin = runnable;
        this.swallow = swlw;
    }

    public VerboseRunnable(final Callable<?> callable, boolean swlw) {
        this.origin = new Runnable(){

            @Override
            public void run() {
                try {
                    callable.call();
                }
                catch (Exception ex) {
                    throw new IllegalArgumentException(ex);
                }
            }

            public String toString() {
                return callable.toString();
            }
        };
        this.swallow = swlw;
    }

    public String toString() {
        return this.origin.toString();
    }

    @Override
    public void run() {
        try {
            this.origin.run();
        }
        catch (RuntimeException ex) {
            if (this.swallow) {
                Logger.warn(this, "swallowed exception: %[exception]s", ex);
            }
            Logger.warn(this, "escalated exception: %[exception]s", ex);
            throw ex;
        }
        catch (Error error) {
            if (this.swallow) {
                Logger.error(this, "swallowed error: %[exception]s", error);
            }
            Logger.error(this, "escalated error: %[exception]s", error);
            throw error;
        }
    }
}

