/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.log;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Level;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.spi.LoggingEvent;

public final class MulticolorLayout
extends PatternLayout {
    private static final String CSI = "\u001b[";
    private static final ConcurrentMap<String, String> COLORS = new ConcurrentHashMap<String, String>(){
        private static final long serialVersionUID = 8441697854235337829L;
        {
            this.put("black", "30");
            this.put("blue", "34");
            this.put("cyan", "36");
            this.put("green", "32");
            this.put("magenta", "35");
            this.put("red", "31");
            this.put("yellow", "33");
            this.put("white", "37");
        }
    };
    private static final ConcurrentMap<Level, String> LEVELS = new ConcurrentHashMap<Level, String>(){
        private static final long serialVersionUID = 8441715446421374053L;
        {
            this.put(Level.TRACE, "2;33");
            this.put(Level.DEBUG, "2;37");
            this.put(Level.INFO, "0;37");
            this.put(Level.WARN, "0;33");
            this.put(Level.ERROR, "0;31");
            this.put(Level.FATAL, "0;35");
        }
    };
    private static final Pattern METAS = Pattern.compile("%color(?:-([a-z]+|[0-9]{1,3};[0-9]{1,3};[0-9]{1,3}))?\\{(.*?)\\}");

    public void setConversionPattern(String pattern) {
        Matcher matcher = METAS.matcher(pattern);
        StringBuffer buf = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(buf, "");
            buf.append(CSI).append(this.ansi(matcher.group(1))).append('m').append(matcher.group(2)).append(CSI).append('m');
        }
        matcher.appendTail(buf);
        super.setConversionPattern(buf.toString());
    }

    public String format(LoggingEvent event) {
        return super.format(event).replace(String.format("%s?m", CSI), String.format("%s%sm", CSI, LEVELS.get(event.getLevel())));
    }

    private String ansi(String meta) {
        String ansi;
        if (meta == null) {
            ansi = "?";
        } else if (meta.matches("[a-z]+")) {
            ansi = (String)COLORS.get(meta);
            if (ansi == null) {
                throw new IllegalArgumentException(String.format("unknown color '%s'", meta));
            }
        } else {
            ansi = meta;
        }
        return ansi;
    }
}

