/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.log;

import com.jcabi.log.DecorException;
import com.jcabi.log.decors.DomDecor;
import com.jcabi.log.decors.ExceptionDecor;
import com.jcabi.log.decors.ListDecor;
import com.jcabi.log.decors.MsDecor;
import com.jcabi.log.decors.NanoDecor;
import com.jcabi.log.decors.ObjectDecor;
import com.jcabi.log.decors.SecretDecor;
import com.jcabi.log.decors.SizeDecor;
import com.jcabi.log.decors.TextDecor;
import com.jcabi.log.decors.TypeDecor;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Formattable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class DecorsManager {
    private static final ConcurrentMap<String, Class<? extends Formattable>> DECORS = new ConcurrentHashMap<String, Class<? extends Formattable>>();

    private DecorsManager() {
    }

    public static Formattable decor(String key, Object arg) throws DecorException {
        Formattable decor;
        Class<? extends Formattable> type = DecorsManager.find(key);
        try {
            decor = (Formattable)DecorsManager.ctor(type).newInstance(arg);
        }
        catch (InstantiationException ex) {
            throw new DecorException(ex, "Can't instantiate %s(%s)", type.getName(), arg.getClass().getName());
        }
        catch (IllegalAccessException ex) {
            throw new DecorException(ex, "Can't access %s(%s)", type.getName(), arg.getClass().getName());
        }
        catch (InvocationTargetException ex) {
            throw new DecorException(ex, "Can't invoke %s(%s)", type.getName(), arg.getClass().getName());
        }
        return decor;
    }

    private static Class<? extends Formattable> find(String key) throws DecorException {
        Class type;
        if (DECORS.containsKey(key)) {
            type = (Class)DECORS.get(key);
        } else {
            try {
                type = Class.forName(key);
            }
            catch (ClassNotFoundException ex) {
                throw new DecorException(ex, "Decor '%s' not found and class can't be instantiated", key);
            }
        }
        return type;
    }

    private static Constructor<?> ctor(Class<? extends Formattable> type) throws DecorException {
        Constructor<?>[] ctors = type.getConstructors();
        if (ctors.length != 1) {
            throw new DecorException("%s should have just one public one-arg ctor, but there are %d", type.getName(), ctors.length);
        }
        Constructor<?> ctor = ctors[0];
        if (ctor.getParameterTypes().length != 1) {
            throw new DecorException("%s public ctor should have just once parameter", type.getName());
        }
        return ctor;
    }

    static {
        DECORS.put("dom", DomDecor.class);
        DECORS.put("exception", ExceptionDecor.class);
        DECORS.put("list", ListDecor.class);
        DECORS.put("ms", MsDecor.class);
        DECORS.put("nano", NanoDecor.class);
        DECORS.put("object", ObjectDecor.class);
        DECORS.put("size", SizeDecor.class);
        DECORS.put("secret", SecretDecor.class);
        DECORS.put("text", TextDecor.class);
        DECORS.put("type", TypeDecor.class);
    }
}

