/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.http.request;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.http.ImmutableHeader;
import com.jcabi.http.Request;
import com.jcabi.http.RequestBody;
import com.jcabi.http.RequestURI;
import com.jcabi.http.Response;
import com.jcabi.http.Wire;
import com.jcabi.immutable.Array;
import com.jcabi.log.Logger;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonStructure;
import javax.validation.constraints.NotNull;
import javax.ws.rs.core.UriBuilder;

@Immutable
@Loggable(value=1)
final class BaseRequest
implements Request {
    private static final String ENCODING = "UTF-8";
    private static final Charset CHARSET = Charset.forName("UTF-8");
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private final transient Wire wire;
    private final transient String home;
    private final transient String mtd;
    private final transient Array<Map.Entry<String, String>> hdrs;
    @Immutable.Array
    private final transient byte[] content;

    BaseRequest(Wire wre, String uri) {
        this(wre, uri, (Iterable<Map.Entry<String, String>>)new Array(), "GET", EMPTY_BYTE_ARRAY);
    }

    BaseRequest(Wire wre, String uri, Iterable<Map.Entry<String, String>> headers, String method, byte[] body) {
        this.wire = wre;
        URI addr = URI.create(uri);
        if (addr.getPath().isEmpty()) {
            addr = UriBuilder.fromUri((URI)addr).path("/").build(new Object[0]);
        }
        this.home = addr.toString();
        this.hdrs = new Array(headers);
        this.mtd = method;
        this.content = (byte[])body.clone();
    }

    @Override
    @NotNull
    public RequestURI uri() {
        return new BaseURI(this, this.home);
    }

    @Override
    public Request header(@NotNull(message="header name can't be NULL") String name, @NotNull(message="header value can't be NULL") Object value) {
        return new BaseRequest(this.wire, this.home, (Iterable<Map.Entry<String, String>>)this.hdrs.with((Object)new ImmutableHeader(name, value.toString())), this.mtd, this.content);
    }

    @Override
    public Request reset(@NotNull(message="header name can't be NULL") String name) {
        LinkedList<Map.Entry<String, String>> headers = new LinkedList<Map.Entry<String, String>>();
        String key = ImmutableHeader.normalize(name);
        for (Map.Entry header : this.hdrs) {
            if (((String)header.getKey()).equals(key)) continue;
            headers.add(header);
        }
        return new BaseRequest(this.wire, this.home, headers, this.mtd, this.content);
    }

    @Override
    public RequestBody body() {
        return new BaseBody(this, this.content);
    }

    @Override
    public Request method(@NotNull(message="method can't be NULL") String method) {
        return new BaseRequest(this.wire, this.home, (Iterable<Map.Entry<String, String>>)this.hdrs, method, this.content);
    }

    @Override
    public Response fetch() throws IOException {
        return this.fetchResponse(new ByteArrayInputStream(this.content));
    }

    @Override
    public Response fetch(InputStream stream) throws IOException {
        if (this.content.length > 0) {
            throw new IllegalStateException("Request Body is not empty, use fetch() instead");
        }
        return this.fetchResponse(stream);
    }

    @Override
    public <T extends Wire> Request through(Class<T> type, Object ... args) {
        Wire decorated;
        Constructor<?> ctor = null;
        for (Constructor<?> opt : type.getDeclaredConstructors()) {
            if (opt.getParameterTypes().length != args.length + 1) continue;
            ctor = opt;
            break;
        }
        if (ctor == null) {
            throw new IllegalArgumentException(String.format("class %s doesn't have a ctor with %d argument(s)", type.getName(), args.length));
        }
        Object[] params = new Object[args.length + 1];
        params[0] = this.wire;
        System.arraycopy(args, 0, params, 1, args.length);
        try {
            decorated = (Wire)Wire.class.cast(ctor.newInstance(params));
        }
        catch (InstantiationException ex) {
            throw new IllegalStateException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalStateException(ex);
        }
        catch (InvocationTargetException ex) {
            throw new IllegalStateException(ex);
        }
        return new BaseRequest(decorated, this.home, (Iterable<Map.Entry<String, String>>)this.hdrs, this.mtd, this.content);
    }

    public String toString() {
        URI uri = URI.create(this.home);
        StringBuilder text = new StringBuilder("HTTP/1.1 ").append(this.mtd).append(' ').append(uri.getPath()).append(" (").append(uri.getHost()).append(")\n");
        for (Map.Entry header : this.hdrs) {
            text.append(Logger.format((String)"%s: %s\n", (Object[])new Object[]{header.getKey(), header.getValue()}));
        }
        return text.append('\n').append(RequestBody.Printable.toString(this.content)).toString();
    }

    private Response fetchResponse(InputStream stream) throws IOException {
        long start = System.currentTimeMillis();
        Response response = this.wire.send(this, this.home, this.mtd, (Collection<Map.Entry<String, String>>)this.hdrs, stream);
        URI uri = URI.create(this.home);
        Logger.info((Object)this, (String)"#fetch(%s %s%s %s): [%d %s] in %[ms]s", (Object[])new Object[]{this.mtd, uri.getHost(), uri.getPort() > 0 ? String.format(":%d", uri.getPort()) : "", uri.getPath(), response.status(), response.reason(), System.currentTimeMillis() - start});
        return response;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseRequest)) {
            return false;
        }
        BaseRequest other = (BaseRequest)o;
        String this$home = this.home;
        String other$home = other.home;
        if (this$home == null ? other$home != null : !this$home.equals(other$home)) {
            return false;
        }
        String this$mtd = this.mtd;
        String other$mtd = other.mtd;
        if (this$mtd == null ? other$mtd != null : !this$mtd.equals(other$mtd)) {
            return false;
        }
        Array<Map.Entry<String, String>> this$hdrs = this.hdrs;
        Array<Map.Entry<String, String>> other$hdrs = other.hdrs;
        if (this$hdrs == null ? other$hdrs != null : !this$hdrs.equals(other$hdrs)) {
            return false;
        }
        return Arrays.equals(this.content, other.content);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $home = this.home;
        result = result * 59 + ($home == null ? 0 : $home.hashCode());
        String $mtd = this.mtd;
        result = result * 59 + ($mtd == null ? 0 : $mtd.hashCode());
        Array<Map.Entry<String, String>> $hdrs = this.hdrs;
        result = result * 59 + ($hdrs == null ? 0 : $hdrs.hashCode());
        result = result * 59 + Arrays.hashCode(this.content);
        return result;
    }

    @Immutable
    @Loggable(value=1)
    private static final class BaseBody
    implements RequestBody {
        @Immutable.Array
        private final transient byte[] text;
        private final transient BaseRequest owner;

        BaseBody(BaseRequest req, byte[] body) {
            this.owner = req;
            this.text = (byte[])body.clone();
        }

        public String toString() {
            return RequestBody.Printable.toString(this.text);
        }

        @Override
        public Request back() {
            return new BaseRequest(this.owner.wire, this.owner.home, (Iterable<Map.Entry<String, String>>)this.owner.hdrs, this.owner.mtd, this.text);
        }

        @Override
        public String get() {
            return new String(this.text, CHARSET);
        }

        @Override
        public RequestBody set(@NotNull(message="content can't be NULL") String txt) {
            return this.set(txt.getBytes(CHARSET));
        }

        @Override
        public RequestBody set(@NotNull(message="JSON can't be NULL") JsonStructure json) {
            StringWriter writer = new StringWriter();
            Json.createWriter((Writer)writer).write(json);
            return this.set(writer.toString());
        }

        @Override
        public RequestBody set(@NotNull(message="body can't be NULL") byte[] txt) {
            return new BaseBody(this.owner, txt);
        }

        @Override
        public RequestBody formParam(@NotNull(message="name can't be NULL") String name, @NotNull(message="value can't be NULL") Object value) {
            try {
                return new BaseBody(this.owner, (this.get() + name + '=' + URLEncoder.encode(value.toString(), BaseRequest.ENCODING) + '&').getBytes(CHARSET));
            }
            catch (UnsupportedEncodingException ex) {
                throw new IllegalStateException(ex);
            }
        }

        @Override
        public RequestBody formParams(@NotNull(message="map of params can't be NULL") Map<String, String> params) {
            RequestBody body = this;
            for (Map.Entry<String, String> param : params.entrySet()) {
                body = body.formParam(param.getKey(), param.getValue());
            }
            return body;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BaseBody)) {
                return false;
            }
            BaseBody other = (BaseBody)o;
            return Arrays.equals(this.text, other.text);
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + Arrays.hashCode(this.text);
            return result;
        }
    }

    @Immutable
    @Loggable(value=1)
    private static final class BaseURI
    implements RequestURI {
        private final transient String address;
        private final transient BaseRequest owner;

        BaseURI(BaseRequest req, String uri) {
            this.owner = req;
            this.address = uri;
        }

        public String toString() {
            return this.address;
        }

        @Override
        public Request back() {
            return new BaseRequest(this.owner.wire, this.address, (Iterable<Map.Entry<String, String>>)this.owner.hdrs, this.owner.mtd, this.owner.content);
        }

        @Override
        public URI get() {
            return URI.create(this.owner.home);
        }

        @Override
        public RequestURI set(@NotNull(message="URI can't be NULL") URI uri) {
            return new BaseURI(this.owner, uri.toString());
        }

        @Override
        public RequestURI queryParam(@NotNull(message="param name can't be NULL") String name, @NotNull(message="value can't be NULL") Object value) {
            return new BaseURI(this.owner, UriBuilder.fromUri((String)this.address).queryParam(name, new Object[]{"{value}"}).build(new Object[]{value}).toString());
        }

        @Override
        public RequestURI queryParams(@NotNull(message="map can't be NULL") Map<String, String> map) {
            UriBuilder uri = UriBuilder.fromUri((String)this.address);
            Object[] values = new Object[map.size()];
            int idx = 0;
            for (Map.Entry<String, String> pair : map.entrySet()) {
                uri.queryParam(pair.getKey(), new Object[]{String.format("{x%d}", idx)});
                values[idx] = pair.getValue();
                ++idx;
            }
            return new BaseURI(this.owner, uri.build(values).toString());
        }

        @Override
        public RequestURI path(@NotNull(message="path can't be NULL") String segment) {
            return new BaseURI(this.owner, UriBuilder.fromUri((String)this.address).path(segment).build(new Object[0]).toString());
        }

        @Override
        public RequestURI userInfo(@NotNull(message="info can't be NULL") String info) {
            return new BaseURI(this.owner, UriBuilder.fromUri((String)this.address).userInfo(info).build(new Object[0]).toString());
        }

        @Override
        public RequestURI port(int num) {
            return new BaseURI(this.owner, UriBuilder.fromUri((String)this.address).port(num).build(new Object[0]).toString());
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BaseURI)) {
                return false;
            }
            BaseURI other = (BaseURI)o;
            String this$address = this.address;
            String other$address = other.address;
            return !(this$address == null ? other$address != null : !this$address.equals(other$address));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $address = this.address;
            result = result * 59 + ($address == null ? 0 : $address.hashCode());
            return result;
        }
    }
}

