/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.http.response;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.aj.ImmutabilityChecker;
import com.jcabi.aspects.aj.MethodValidator;
import com.jcabi.http.Response;
import com.jcabi.http.response.AbstractResponse;
import java.io.Reader;
import java.io.StringReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonStructure;
import javax.json.stream.JsonParsingException;
import javax.validation.constraints.NotNull;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

@Immutable
public final class JsonResponse
extends AbstractResponse {
    private static final Pattern CONTROL;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

    public JsonResponse(@NotNull(message="response can't be NULL") Response resp) {
        super(resp);
        Response response = resp;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)response);
        try {
            MethodValidator.aspectOf().beforeCtor(joinPoint);
        }
        finally {
            ImmutabilityChecker.aspectOf().after(joinPoint);
        }
    }

    @NotNull(message="JSON response is never NULL")
    public JsonResponse assertJson(@NotNull(message="JSON query can't be NULL") String element) {
        String string = element;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)string);
        MethodValidator.aspectOf().beforeMethod(joinPoint);
        throw new UnsupportedOperationException("assertJson() is not implemented yet, since we are not sure which JSON query standard to use");
    }

    @NotNull(message="JSON reader is never NULL")
    public JsonReader json() {
        VerboseReader verboseReader;
        VerboseReader verboseReader2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        String body = this.body();
        VerboseReader verboseReader3 = verboseReader2 = (verboseReader = new VerboseReader(Json.createReader((Reader)new StringReader(JsonResponse.escape(body))), body));
        MethodValidator.aspectOf().after(joinPoint, (Object)verboseReader2);
        return verboseReader;
    }

    private static String escape(CharSequence input) {
        Matcher matcher = CONTROL.matcher(input);
        StringBuffer escaped = new StringBuffer(input.length());
        while (matcher.find()) {
            matcher.appendReplacement(escaped, String.format("\\\\u%04X", matcher.group().charAt(0)));
        }
        matcher.appendTail(escaped);
        return escaped.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JsonResponse)) {
            return false;
        }
        JsonResponse other = (JsonResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    public boolean canEqual(Object other) {
        return other instanceof JsonResponse;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        return result;
    }

    static {
        JsonResponse.ajc$preClinit();
        CONTROL = Pattern.compile("[\u0000-\u001f]");
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("JsonResponse.java", JsonResponse.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "assertJson", "com.jcabi.http.response.JsonResponse", "java.lang.String", "element", "", "com.jcabi.http.response.JsonResponse"), 94);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "json", "com.jcabi.http.response.JsonResponse", "", "", "", "javax.json.JsonReader"), 106);
        ajc$tjp_2 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("1", "com.jcabi.http.response.JsonResponse", "com.jcabi.http.Response", "resp", ""), 82);
    }

    private static final class VerboseReader
    implements JsonReader {
        private final transient JsonReader origin;
        private final transient String json;

        VerboseReader(JsonReader reader, String body) {
            this.origin = reader;
            this.json = body;
        }

        public JsonObject readObject() {
            try {
                return this.origin.readObject();
            }
            catch (JsonParsingException ex) {
                throw new JsonParsingException(this.json, (Throwable)ex, ex.getLocation());
            }
        }

        public JsonArray readArray() {
            try {
                return this.origin.readArray();
            }
            catch (JsonParsingException ex) {
                throw new JsonParsingException(this.json, (Throwable)ex, ex.getLocation());
            }
        }

        public JsonStructure read() {
            try {
                return this.origin.read();
            }
            catch (JsonParsingException ex) {
                throw new JsonParsingException(this.json, (Throwable)ex, ex.getLocation());
            }
        }

        public void close() {
            this.origin.close();
        }
    }
}

