/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.http.mock;

import com.jcabi.http.mock.GrizzlyQuery;
import com.jcabi.http.mock.MkAnswer;
import com.jcabi.http.mock.MkQuery;
import com.jcabi.log.Logger;
import com.sun.grizzly.tcp.http11.GrizzlyAdapter;
import com.sun.grizzly.tcp.http11.GrizzlyRequest;
import com.sun.grizzly.tcp.http11.GrizzlyResponse;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.commons.io.Charsets;

final class MkGrizzlyAdapter
extends GrizzlyAdapter {
    private final transient Queue<MkQuery> queue = new ConcurrentLinkedQueue<MkQuery>();
    private final transient Queue<MkAnswer> answers = new ConcurrentLinkedQueue<MkAnswer>();

    MkGrizzlyAdapter() {
    }

    public void service(GrizzlyRequest request, GrizzlyResponse response) {
        try {
            this.queue.add(new GrizzlyQuery(request));
            MkAnswer answer = this.answers.remove();
            for (String name : answer.headers().keySet()) {
                for (String value : answer.headers().get(name)) {
                    response.addHeader(name, value);
                }
            }
            response.addHeader("Server", String.format("%s query #%d, %d answer(s) left", ((Object)((Object)this)).getClass().getName(), this.queue.size(), this.answers.size()));
            response.setStatus(answer.status());
            byte[] body = answer.body().getBytes(Charsets.UTF_8);
            response.getStream().write(body);
            response.setContentLength(body.length);
        }
        catch (Throwable ex) {
            MkGrizzlyAdapter.fail(response, ex);
        }
    }

    public void next(MkAnswer answer) {
        this.answers.add(answer);
    }

    public MkQuery take() {
        return this.queue.remove();
    }

    public int queries() {
        return this.queue.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fail(GrizzlyResponse<?> response, Throwable failure) {
        PrintWriter writer;
        response.setStatus(500);
        try {
            writer = new PrintWriter(new OutputStreamWriter(response.getStream(), "UTF-8"));
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalStateException(ex);
        }
        try {
            writer.print(Logger.format((String)"%[exception]s", (Object[])new Object[]{failure}));
        }
        finally {
            writer.close();
        }
    }
}

