/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.http.mock;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.aj.ImmutabilityChecker;
import com.jcabi.http.ImmutableHeader;
import com.jcabi.http.mock.MkQuery;
import com.jcabi.immutable.ArrayMap;
import com.sun.grizzly.tcp.http11.GrizzlyRequest;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.IOUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

@Immutable
final class GrizzlyQuery
implements MkQuery {
    private final transient String mtd;
    private final transient byte[] content;
    private final transient String home;
    private final transient ArrayMap<String, List<String>> hdrs;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    GrizzlyQuery(GrizzlyRequest request) throws IOException {
        GrizzlyRequest grizzlyRequest = request;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)grizzlyRequest);
        try {
            JoinPoint joinPoint2 = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
            try {
            }
            finally {
                ImmutabilityChecker.aspectOf().after(joinPoint2);
            }
            request.setCharacterEncoding("UTF-8");
            this.home = GrizzlyQuery.uri(request);
            this.mtd = request.getMethod();
            this.hdrs = GrizzlyQuery.headers(request);
            this.content = IOUtils.toByteArray((InputStream)request.getInputStream());
        }
        finally {
            ImmutabilityChecker.aspectOf().after(joinPoint);
        }
    }

    @Override
    public URI uri() {
        return URI.create(this.home);
    }

    @Override
    public String method() {
        return this.mtd;
    }

    @Override
    public Map<String, List<String>> headers() {
        return Collections.unmodifiableMap(this.hdrs);
    }

    @Override
    public String body() {
        return new String(this.content, Charsets.UTF_8);
    }

    private static String uri(GrizzlyRequest request) {
        StringBuilder uri = new StringBuilder(request.getRequestURI());
        String query = request.getQueryString();
        if (query != null && !query.isEmpty()) {
            uri.append('?').append(query);
        }
        return uri.toString();
    }

    private static ArrayMap<String, List<String>> headers(GrizzlyRequest request) {
        ConcurrentHashMap<String, List<String>> headers = new ConcurrentHashMap<String, List<String>>(0);
        Enumeration names = request.getHeaderNames();
        while (names.hasMoreElements()) {
            String name = names.nextElement().toString();
            headers.put(ImmutableHeader.normalize(name), GrizzlyQuery.headers(request, name));
        }
        return new ArrayMap(headers);
    }

    private static List<String> headers(GrizzlyRequest request, String name) {
        LinkedList<String> list = new LinkedList<String>();
        Enumeration values = request.getHeaders(name);
        while (values.hasMoreElements()) {
            list.add(values.nextElement().toString());
        }
        return list;
    }

    static {
        GrizzlyQuery.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("GrizzlyQuery.java", GrizzlyQuery.class);
        ajc$tjp_0 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("1", "com.jcabi.http.mock.MkQuery", "", "", ""), 84);
        ajc$tjp_1 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("0", "com.jcabi.http.mock.GrizzlyQuery", "com.sun.grizzly.tcp.http11.GrizzlyRequest", "request", "java.io.IOException"), 84);
    }
}

