/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.http.wire;

import com.jcabi.aspects.Immutable;
import com.jcabi.http.Request;
import com.jcabi.http.Response;
import com.jcabi.http.Wire;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

@Immutable
public final class AutoRedirectingWire
implements Wire {
    private final transient Wire origin;
    private final transient int max;

    public AutoRedirectingWire(Wire wire) {
        this(wire, 5);
    }

    public AutoRedirectingWire(Wire wire, int retries) {
        this.origin = wire;
        this.max = retries;
    }

    @Override
    public Response send(Request req, String home, String method, Collection<Map.Entry<String, String>> headers, InputStream content, int connect, int read) throws IOException {
        List<String> locations;
        Response response = this.origin.send(req, home, method, headers, content, connect, read);
        URI uri = URI.create(home);
        for (int attempt = 1; attempt < this.max && response.status() >= 300 && response.status() < 400 && (locations = response.headers().get("Location")) != null && locations.size() == 1; ++attempt) {
            URI location = URI.create(locations.get(0));
            if (!location.isAbsolute()) {
                location = uri.resolve(location);
            }
            response = this.origin.send(req, location.toString(), method, headers, content, connect, read);
            try {
                TimeUnit.SECONDS.sleep(attempt);
                continue;
            }
            catch (InterruptedException ex) {
                throw new IOException(ex);
            }
        }
        return response;
    }

    public String toString() {
        return "AutoRedirectingWire(origin=" + this.origin + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AutoRedirectingWire)) {
            return false;
        }
        AutoRedirectingWire other = (AutoRedirectingWire)o;
        if (this.max != other.max) {
            return false;
        }
        Wire this$origin = this.origin;
        Wire other$origin = other.origin;
        return !(this$origin == null ? other$origin != null : !this$origin.equals(other$origin));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.max;
        Wire $origin = this.origin;
        result = result * 59 + ($origin == null ? 43 : $origin.hashCode());
        return result;
    }
}

