/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.http.response;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.jcabi.aspects.Immutable;
import com.jcabi.http.Response;
import com.jcabi.http.response.AbstractResponse;
import java.io.IOException;
import java.util.Arrays;

@Immutable
public final class JacksonResponse
extends AbstractResponse {
    public JacksonResponse(Response resp) {
        super(resp);
    }

    public JsonReader json() {
        return new JsonReader(this.binary());
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JacksonResponse)) {
            return false;
        }
        JacksonResponse other = (JacksonResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof JacksonResponse;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    public static final class JsonReader {
        private static final ObjectMapper MAPPER = new ObjectMapper().configure(JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS, true);
        private final transient byte[] body;

        public JsonReader(byte[] bytes) {
            this.body = Arrays.copyOf(bytes, bytes.length);
        }

        public ArrayNode readArray() throws IOException {
            JsonNode node = this.read();
            if (!node.isArray()) {
                throw new IOException("Cannot read as an array. The JSON is not a valid array.");
            }
            return (ArrayNode)node;
        }

        public ObjectNode readObject() throws IOException {
            JsonNode node = this.read();
            if (!node.isObject()) {
                throw new IOException("Cannot read as an object. The JSON is not a valid object.");
            }
            return (ObjectNode)node;
        }

        public JsonNode read() throws IOException {
            return MAPPER.readTree(this.body);
        }
    }
}

