/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.http.request;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.http.ImmutableHeader;
import com.jcabi.http.Request;
import com.jcabi.http.RequestBody;
import com.jcabi.http.RequestURI;
import com.jcabi.http.Response;
import com.jcabi.http.Wire;
import com.jcabi.http.request.BaseRequest;
import com.jcabi.http.request.DefaultResponse;
import com.jcabi.immutable.Array;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

@Immutable
@Loggable(value=1)
public final class ApacheRequest
implements Request {
    private static final Wire WIRE = new Wire(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Response send(Request req, String home, String method, Collection<Map.Entry<String, String>> headers, InputStream content, int connect, int read) throws IOException {
            try (CloseableHttpResponse response = HttpClients.createSystem().execute((HttpUriRequest)this.httpRequest(home, method, headers, content, connect, read));){
                DefaultResponse defaultResponse = new DefaultResponse(req, response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase(), this.headers(response.getAllHeaders()), this.consume(response.getEntity()));
                return defaultResponse;
            }
        }

        public HttpEntityEnclosingRequestBase httpRequest(String home, final String method, Collection<Map.Entry<String, String>> headers, InputStream content, int connect, int read) throws IOException {
            HttpEntityEnclosingRequestBase req = new HttpEntityEnclosingRequestBase(){

                public String getMethod() {
                    return method;
                }
            };
            URI uri = URI.create(home);
            req.setConfig(RequestConfig.custom().setCircularRedirectsAllowed(false).setRedirectsEnabled(false).setConnectTimeout(connect).setSocketTimeout(read).build());
            req.setURI(uri);
            req.setEntity((HttpEntity)new BufferedHttpEntity((HttpEntity)new InputStreamEntity(content)));
            for (Map.Entry<String, String> header : headers) {
                req.addHeader(header.getKey(), header.getValue());
            }
            return req;
        }

        private byte[] consume(HttpEntity entity) throws IOException {
            byte[] body = entity == null ? new byte[]{} : EntityUtils.toByteArray((HttpEntity)entity);
            return body;
        }

        private Array<Map.Entry<String, String>> headers(Header ... list) {
            LinkedList<ImmutableHeader> headers = new LinkedList<ImmutableHeader>();
            for (Header header : list) {
                headers.add(new ImmutableHeader(header.getName(), header.getValue()));
            }
            return new Array(headers);
        }
    };
    private final transient Request base;

    public ApacheRequest(URL url) {
        this(url.toString());
    }

    public ApacheRequest(URI uri) {
        this(uri.toString());
    }

    public ApacheRequest(String uri) {
        this.base = new BaseRequest(WIRE, uri);
    }

    @Override
    public RequestURI uri() {
        return this.base.uri();
    }

    @Override
    public Request header(String name, Object value) {
        return this.base.header(name, value);
    }

    @Override
    public Request reset(String name) {
        return this.base.reset(name);
    }

    @Override
    public RequestBody body() {
        return this.base.body();
    }

    @Override
    public RequestBody multipartBody() {
        return this.base.multipartBody();
    }

    @Override
    public Request method(String method) {
        return this.base.method(method);
    }

    @Override
    public Request timeout(int connect, int read) {
        return this.base.timeout(connect, read);
    }

    @Override
    public Response fetch() throws IOException {
        return this.base.fetch();
    }

    @Override
    public Response fetch(InputStream stream) throws IOException {
        return this.base.fetch(stream);
    }

    @Override
    public <T extends Wire> Request through(Class<T> type, Object ... args) {
        return this.base.through(type, args);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ApacheRequest)) {
            return false;
        }
        ApacheRequest other = (ApacheRequest)o;
        Request this$base = this.base;
        Request other$base = other.base;
        return !(this$base == null ? other$base != null : !this$base.equals(other$base));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Request $base = this.base;
        result = result * 59 + ($base == null ? 43 : $base.hashCode());
        return result;
    }

    public String toString() {
        return "ApacheRequest(base=" + this.base + ")";
    }
}

