/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.http.wire;

import com.google.common.base.Joiner;
import com.jcabi.aspects.Immutable;
import com.jcabi.http.Request;
import com.jcabi.http.Response;
import com.jcabi.http.Wire;
import com.jcabi.http.request.DefaultResponse;
import com.jcabi.immutable.Array;
import com.jcabi.log.Logger;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonString;
import javax.json.JsonStructure;
import org.apache.commons.io.FileUtils;

@Immutable
final class FcCache {
    private final transient String dir;

    FcCache() {
        this(new File(new File(System.getProperty("java.io.tmpdir")), String.format("%s-%d", FcCache.class.getCanonicalName(), System.nanoTime())).getAbsolutePath());
    }

    FcCache(String path) {
        this.dir = path;
    }

    public void invalidate() throws IOException {
        File file = this.file("").getParentFile();
        if (file.exists()) {
            FileUtils.deleteDirectory((File)file);
            Logger.debug((Object)this, (String)"cache invalidated in %s", (Object[])new Object[]{file});
        }
    }

    public Response get(String label, Wire wire, Request request, String home, String method, Collection<Map.Entry<String, String>> headers, InputStream input, int connect, int read) throws IOException {
        File file = this.file(label);
        Response rsp = file.exists() ? this.response(request, file) : this.saved(wire.send(request, home, method, headers, input, connect, read), file);
        return rsp;
    }

    private Response response(Request req, File file) throws IOException {
        JsonObject json = Json.createReader((InputStream)new ByteArrayInputStream(FileUtils.readFileToByteArray((File)file))).readObject();
        LinkedList<AbstractMap.SimpleEntry<String, String>> map = new LinkedList<AbstractMap.SimpleEntry<String, String>>();
        JsonObject headers = json.getJsonObject("headers");
        for (String name : headers.keySet()) {
            for (JsonString value : headers.getJsonArray(name).getValuesAs(JsonString.class)) {
                map.add(new AbstractMap.SimpleEntry<String, String>(name, value.getString()));
            }
        }
        Logger.debug((Object)this, (String)"cache loaded from %s", (Object[])new Object[]{file});
        return new DefaultResponse(req, json.getInt("status"), json.getString("reason"), (Array<Map.Entry<String, String>>)new Array(map), json.getString("body").getBytes("UTF-8"));
    }

    private Response saved(Response response, File file) throws IOException {
        JsonObjectBuilder json = Json.createObjectBuilder();
        json.add("status", response.status());
        json.add("reason", response.reason());
        JsonObjectBuilder headers = Json.createObjectBuilder();
        for (Map.Entry<String, List<String>> pair : response.headers().entrySet()) {
            JsonArrayBuilder array = Json.createArrayBuilder();
            for (String value : pair.getValue()) {
                array.add(value);
            }
            headers.add(pair.getKey(), array);
        }
        json.add("headers", headers);
        json.add("body", response.body());
        if (file.getParentFile().mkdirs()) {
            Logger.debug((Object)this, (String)"directory created for %s", (Object[])new Object[]{file});
        }
        try (FileOutputStream out = new FileOutputStream(file);){
            Json.createWriter((OutputStream)out).write((JsonStructure)json.build());
        }
        Logger.debug((Object)this, (String)"cache saved into %s", (Object[])new Object[]{file});
        return response;
    }

    private File file(String label) {
        String path;
        try {
            path = Joiner.on((String)"/").join((Object[])URLEncoder.encode(label, "UTF-8").replaceAll("_", "__").replaceAll("\\+", "_").replaceAll("%", "_").split("(?<=\\G.{4})"));
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalStateException(ex);
        }
        return new File(this.dir, String.format("%s.json", path));
    }

    public String toString() {
        return "FcCache(dir=" + this.dir + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        return o instanceof FcCache;
    }

    public int hashCode() {
        int result = 1;
        return result;
    }
}

