/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.http.wire;

import com.jcabi.aspects.Immutable;
import com.jcabi.http.Request;
import com.jcabi.http.Response;
import com.jcabi.http.Wire;
import com.jcabi.log.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Map;
import javax.validation.constraints.NotNull;

@Immutable
public final class RetryWire
implements Wire {
    private final transient Wire origin;

    public RetryWire(@NotNull(message="wire can't be NULL") Wire wire) {
        this.origin = wire;
    }

    @Override
    public Response send(Request req, String home, String method, Collection<Map.Entry<String, String>> headers, InputStream content, int connect, int read) throws IOException {
        int attempt = 0;
        while (true) {
            if (attempt > 3) {
                throw new IOException(String.format("failed after %d attempts", attempt));
            }
            try {
                Response rsp = this.origin.send(req, home, method, headers, content, connect, read);
                if (rsp.status() < 500) {
                    return rsp;
                }
                Logger.warn((Object)this, (String)"%s %s returns %d status (attempt #%d)", (Object[])new Object[]{method, home, rsp.status(), attempt + 1});
            }
            catch (IOException ex) {
                Logger.warn((Object)this, (String)"%s: %s", (Object[])new Object[]{ex.getClass().getName(), ex.getLocalizedMessage()});
            }
            ++attempt;
        }
    }

    public String toString() {
        return "RetryWire(origin=" + this.origin + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RetryWire)) {
            return false;
        }
        RetryWire other = (RetryWire)o;
        Wire this$origin = this.origin;
        Wire other$origin = other.origin;
        return !(this$origin == null ? other$origin != null : !this$origin.equals(other$origin));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Wire $origin = this.origin;
        result = result * 59 + ($origin == null ? 0 : $origin.hashCode());
        return result;
    }
}

