/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.http.wire;

import com.jcabi.aspects.Immutable;
import com.jcabi.http.ImmutableHeader;
import com.jcabi.http.Request;
import com.jcabi.http.Response;
import com.jcabi.http.Wire;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.validation.constraints.NotNull;

@Immutable
public final class CookieOptimizingWire
implements Wire {
    private final transient Wire origin;

    public CookieOptimizingWire(@NotNull(message="wire can't be NULL") Wire wire) {
        this.origin = wire;
    }

    @Override
    public Response send(Request req, String home, String method, Collection<Map.Entry<String, String>> headers, InputStream content, int connect, int read) throws IOException {
        LinkedList<Map.Entry<String, String>> hdrs = new LinkedList<Map.Entry<String, String>>();
        ConcurrentHashMap<String, String> cookies = new ConcurrentHashMap<String, String>(0);
        for (Map.Entry<String, String> header : headers) {
            if (header.getKey().equals("Cookie")) {
                Map.Entry cookie = header.getValue();
                int split = ((String)((Object)cookie)).indexOf(61);
                String name = ((String)((Object)cookie)).substring(0, split);
                String value = ((String)((Object)cookie)).substring(split + 1);
                if (value.isEmpty()) {
                    cookies.remove(name);
                    continue;
                }
                cookies.put(name, value);
                continue;
            }
            hdrs.add(header);
        }
        if (!cookies.isEmpty()) {
            StringBuilder text = new StringBuilder(0);
            for (Map.Entry cookie : cookies.entrySet()) {
                if (((String)cookie.getValue()).isEmpty()) continue;
                if (text.length() > 0) {
                    text.append("; ");
                }
                text.append((String)cookie.getKey()).append('=').append((String)cookie.getValue());
            }
            hdrs.add(new ImmutableHeader("Cookie", text.toString()));
        }
        return this.origin.send(req, home, method, hdrs, content, connect, read);
    }

    public String toString() {
        return "CookieOptimizingWire(origin=" + this.origin + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CookieOptimizingWire)) {
            return false;
        }
        CookieOptimizingWire other = (CookieOptimizingWire)o;
        Wire this$origin = this.origin;
        Wire other$origin = other.origin;
        return !(this$origin == null ? other$origin != null : !this$origin.equals(other$origin));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Wire $origin = this.origin;
        result = result * 59 + ($origin == null ? 0 : $origin.hashCode());
        return result;
    }
}

