/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.http.response;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.aj.ImmutabilityChecker;
import com.jcabi.aspects.aj.MethodValidator;
import com.jcabi.http.Request;
import com.jcabi.http.Response;
import com.jcabi.http.response.AbstractResponse;
import com.jcabi.http.response.RestResponse;
import com.jcabi.immutable.ArrayMap;
import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

@Immutable
public final class WebLinkingResponse
extends AbstractResponse {
    private static final String HEADER = "Link";
    private static final String REL = "rel";
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

    public WebLinkingResponse(@NotNull(message="response can't be NULL") Response resp) {
        super(resp);
        Response response = resp;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)response);
        try {
            MethodValidator.aspectOf().beforeCtor(joinPoint);
        }
        finally {
            ImmutabilityChecker.aspectOf().after(joinPoint);
        }
    }

    @NotNull(message="response is never NULL")
    public Request follow(@NotNull(message="rel can't be NULL") String rel) throws IOException {
        Request request;
        Request request2;
        String string = rel;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)string);
        MethodValidator.aspectOf().beforeMethod(joinPoint);
        Link link = this.links().get(rel);
        if (link == null) {
            throw new IOException(String.format("Link with rel=\"%s\" doesn't exist, use #hasLink()", rel));
        }
        Request request3 = request2 = (request = new RestResponse(this).jump(link.uri()));
        MethodValidator.aspectOf().after(joinPoint, (Object)request2);
        return request;
    }

    @NotNull(message="list of links is never NULL")
    public Map<String, Link> links() throws IOException {
        ConcurrentHashMap<String, Link> concurrentHashMap;
        ConcurrentHashMap<String, Link> concurrentHashMap2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        ConcurrentHashMap<String, Link> links = new ConcurrentHashMap<String, Link>();
        Collection headers = this.headers().get(HEADER);
        if (headers != null) {
            for (String header : headers) {
                for (String part : header.split(",")) {
                    SimpleLink link = new SimpleLink(part.trim());
                    String rel = (String)link.get(REL);
                    if (rel == null) continue;
                    links.put(rel, link);
                }
            }
        }
        ConcurrentHashMap<String, Link> concurrentHashMap3 = concurrentHashMap2 = (concurrentHashMap = links);
        MethodValidator.aspectOf().after(joinPoint, concurrentHashMap2);
        return concurrentHashMap;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WebLinkingResponse)) {
            return false;
        }
        WebLinkingResponse other = (WebLinkingResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    public boolean canEqual(Object other) {
        return other instanceof WebLinkingResponse;
    }

    @Override
    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = result * 31 + super.hashCode();
        return result;
    }

    static {
        WebLinkingResponse.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("WebLinkingResponse.java", WebLinkingResponse.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "follow", "com.jcabi.http.response.WebLinkingResponse", "java.lang.String", REL, "java.io.IOException", "com.jcabi.http.Request"), 104);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "links", "com.jcabi.http.response.WebLinkingResponse", "", "", "java.io.IOException", "java.util.Map"), 124);
        ajc$tjp_2 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("1", "com.jcabi.http.response.WebLinkingResponse", "com.jcabi.http.Response", "resp", ""), 93);
    }

    @Immutable
    private static final class SimpleLink
    implements Link {
        private static final Pattern PTN;
        private final transient String addr;
        private final transient ArrayMap<String, String> params;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

        SimpleLink(String text) throws IOException {
            String string = text;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)string);
            try {
                JoinPoint joinPoint2 = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
                try {
                }
                finally {
                    ImmutabilityChecker.aspectOf().after(joinPoint2);
                }
                ConcurrentHashMap<String, String> args = new ConcurrentHashMap<String, String>();
                Matcher matcher = PTN.matcher(text);
                if (!matcher.matches()) {
                    throw new IOException(String.format("Link header value doesn't comply to RFC-5988: \"%s\"", text));
                }
                this.addr = matcher.group(1);
                for (String pair : matcher.group(2).trim().split("\\s*;\\s*")) {
                    String[] parts = pair.split("=");
                    args.put(parts[0].trim().toLowerCase(Locale.ENGLISH), StringUtils.strip((String)parts[1].trim(), (String)"\""));
                }
                this.params = new ArrayMap(args);
            }
            finally {
                ImmutabilityChecker.aspectOf().after(joinPoint);
            }
        }

        @Override
        public URI uri() {
            return URI.create(this.addr);
        }

        @Override
        public int size() {
            return this.params.size();
        }

        @Override
        public boolean isEmpty() {
            return this.params.isEmpty();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.params.containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            return this.params.containsValue(value);
        }

        @Override
        public String get(Object key) {
            return (String)this.params.get(key);
        }

        @Override
        public String put(String key, String value) {
            throw new UnsupportedOperationException("#put()");
        }

        @Override
        public String remove(Object key) {
            throw new UnsupportedOperationException("#remove()");
        }

        @Override
        public void putAll(Map<? extends String, ? extends String> map) {
            throw new UnsupportedOperationException("#putAll()");
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException("#clear()");
        }

        @Override
        public Set<String> keySet() {
            return this.params.keySet();
        }

        @Override
        public Collection<String> values() {
            return this.params.values();
        }

        @Override
        public Set<Map.Entry<String, String>> entrySet() {
            return this.params.entrySet();
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            return o instanceof SimpleLink;
        }

        @Override
        public int hashCode() {
            int result = 1;
            return result;
        }

        static {
            SimpleLink.ajc$preClinit();
            PTN = Pattern.compile("<([^>]+)>\\s*;(.*)");
        }

        private static /* synthetic */ void ajc$preClinit() {
            Factory factory = new Factory("WebLinkingResponse.java", SimpleLink.class);
            ajc$tjp_0 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("1", "com.jcabi.http.response.WebLinkingResponse$Link", "", "", ""), 180);
            ajc$tjp_1 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("0", "com.jcabi.http.response.WebLinkingResponse$SimpleLink", "java.lang.String", "text", "java.io.IOException"), 180);
        }
    }

    @Immutable
    public static interface Link
    extends Map<String, String> {
        public URI uri();
    }
}

