/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github.mock;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.Coordinates;
import com.jcabi.github.Github;
import com.jcabi.github.Release;
import com.jcabi.github.Releases;
import com.jcabi.github.Repo;
import com.jcabi.github.mock.MkIterable;
import com.jcabi.github.mock.MkRelease;
import com.jcabi.github.mock.MkRepo;
import com.jcabi.github.mock.MkStorage;
import java.io.IOException;
import org.xembly.Directive;
import org.xembly.Directives;

@Immutable
@Loggable(value=1)
final class MkReleases
implements Releases {
    private final transient MkStorage storage;
    private final transient String self;
    private final transient Coordinates coords;

    public MkReleases(MkStorage stg, String login, Coordinates rep) throws IOException {
        this.storage = stg;
        this.self = login;
        this.coords = rep;
        this.storage.apply((Iterable<Directive>)new Directives().xpath((Object)String.format("/github/repos/repo[@coords='%s']", this.coords)).addIf((Object)"releases"));
    }

    @Override
    public Repo repo() {
        return new MkRepo(this.storage, this.self, this.coords);
    }

    @Override
    public Iterable<Release> iterate() {
        return new MkIterable<Release>(this.storage, String.format("%s/release", this.xpath()), xml -> this.get(Integer.parseInt((String)xml.xpath("id/text()").get(0))));
    }

    @Override
    public Release get(int number) {
        return new MkRelease(this.storage, this.self, this.coords, number);
    }

    @Override
    public Release create(String tag) throws IOException {
        int number;
        this.storage.lock();
        try {
            number = 1 + this.storage.xml().xpath(String.format("%s/release/id/text()", this.xpath())).size();
            this.storage.apply((Iterable<Directive>)new Directives().xpath((Object)this.xpath()).add((Object)"release").add((Object)"id").set((Object)Integer.toString(number)).up().add((Object)"tag_name").set((Object)tag).up().add((Object)"target_commitish").set((Object)"master").up().add((Object)"name").set((Object)"").up().add((Object)"body").set((Object)"").up().add((Object)"draft").set((Object)"true").up().add((Object)"prerelease").set((Object)"false").up().add((Object)"created_at").set((Object)new Github.Time().toString()).up().add((Object)"published_at").set((Object)new Github.Time().toString()).up().add((Object)"url").set((Object)"http://localhost/1").up().add((Object)"html_url").set((Object)"http://localhost/2").up().add((Object)"assets_url").set((Object)"http://localhost/3").up().add((Object)"upload_url").set((Object)"http://localhost/4").up());
        }
        finally {
            this.storage.unlock();
        }
        return this.get(number);
    }

    @Override
    public void remove(int number) throws IOException {
        this.storage.lock();
        try {
            this.storage.apply((Iterable<Directive>)new Directives().xpath((Object)String.format("%s/release[id='%d']", this.xpath(), number)).remove());
        }
        finally {
            this.storage.unlock();
        }
    }

    private String xpath() {
        return String.format("/github/repos/repo[@coords='%s']/releases", this.coords);
    }

    public String toString() {
        return "MkReleases(storage=" + this.storage + ", self=" + this.self + ", coords=" + this.coords + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MkReleases)) {
            return false;
        }
        MkReleases other = (MkReleases)o;
        MkStorage this$storage = this.storage;
        MkStorage other$storage = other.storage;
        if (this$storage == null ? other$storage != null : !this$storage.equals(other$storage)) {
            return false;
        }
        String this$self = this.self;
        String other$self = other.self;
        if (this$self == null ? other$self != null : !this$self.equals(other$self)) {
            return false;
        }
        Coordinates this$coords = this.coords;
        Coordinates other$coords = other.coords;
        return !(this$coords == null ? other$coords != null : !this$coords.equals(other$coords));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MkStorage $storage = this.storage;
        result = result * 59 + ($storage == null ? 43 : $storage.hashCode());
        String $self = this.self;
        result = result * 59 + ($self == null ? 43 : $self.hashCode());
        Coordinates $coords = this.coords;
        result = result * 59 + ($coords == null ? 43 : $coords.hashCode());
        return result;
    }
}

