/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.Gist;
import com.jcabi.github.GistComment;
import com.jcabi.github.GistComments;
import com.jcabi.github.RtGistComment;
import com.jcabi.github.RtPagination;
import com.jcabi.http.Request;
import com.jcabi.http.response.JsonResponse;
import com.jcabi.http.response.RestResponse;
import java.io.IOException;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonStructure;

@Immutable
@Loggable(value=1)
final class RtGistComments
implements GistComments {
    private final transient Request entry;
    private final transient Request request;
    private final transient Gist owner;

    RtGistComments(Request req, Gist gist) {
        this.entry = req;
        this.request = this.entry.uri().path("/gists").path(gist.identifier()).path("/comments").back();
        this.owner = gist;
    }

    public String toString() {
        return this.request.uri().get().toString();
    }

    @Override
    public Gist gist() {
        return this.owner;
    }

    @Override
    public GistComment get(int number) {
        return new RtGistComment(this.entry, this.owner, number);
    }

    @Override
    public GistComment post(String text) throws IOException {
        JsonObject json = Json.createObjectBuilder().add("body", text).build();
        return this.get(((JsonResponse)((RestResponse)this.request.method("POST").body().set((JsonStructure)json).back().fetch().as(RestResponse.class)).assertStatus(201).as(JsonResponse.class)).json().readObject().getInt("id"));
    }

    @Override
    public Iterable<GistComment> iterate() {
        return new RtPagination<GistComment>(this.request, object -> this.get(object.getInt("id")));
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RtGistComments)) {
            return false;
        }
        RtGistComments other = (RtGistComments)o;
        Request this$request = this.request;
        Request other$request = other.request;
        if (this$request == null ? other$request != null : !this$request.equals(other$request)) {
            return false;
        }
        Gist this$owner = this.owner;
        Gist other$owner = other.owner;
        return !(this$owner == null ? other$owner != null : !this$owner.equals(other$owner));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Request $request = this.request;
        result = result * 59 + ($request == null ? 43 : $request.hashCode());
        Gist $owner = this.owner;
        result = result * 59 + ($owner == null ? 43 : $owner.hashCode());
        return result;
    }
}

