/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.JsonPatchable;
import com.jcabi.github.JsonReadable;
import com.jcabi.github.Pull;
import com.jcabi.github.Reaction;
import com.jcabi.github.SmartJson;
import java.io.IOException;
import java.util.Collection;
import javax.json.Json;
import javax.json.JsonObject;

@Immutable
public interface PullComment
extends JsonReadable,
JsonPatchable,
Comparable<PullComment> {
    public Pull pull();

    public int number();

    public void react(Reaction var1);

    public Collection<Reaction> reactions();

    @Immutable
    @Loggable(value=1)
    public static final class Smart
    implements PullComment {
        private static final String ID = "id";
        private static final String COMMIT_ID = "commit_id";
        private static final String URL = "url";
        private static final String BODY = "body";
        private final transient PullComment cmnt;
        private final transient SmartJson jsn;

        public Smart(PullComment pcomment) {
            this.cmnt = pcomment;
            this.jsn = new SmartJson(pcomment);
        }

        public String identifier() throws IOException {
            return this.jsn.text(ID);
        }

        public void identifier(String value) throws IOException {
            this.cmnt.patch(Json.createObjectBuilder().add(ID, value).build());
        }

        public String commitId() throws IOException {
            return this.jsn.text(COMMIT_ID);
        }

        public void commitId(String value) throws IOException {
            this.cmnt.patch(Json.createObjectBuilder().add(COMMIT_ID, value).build());
        }

        public String url() throws IOException {
            return this.jsn.text(URL);
        }

        public int reply() throws IOException {
            return this.jsn.number("in_reply_to");
        }

        public void url(String value) throws IOException {
            this.cmnt.patch(Json.createObjectBuilder().add(URL, value).build());
        }

        public String body() throws IOException {
            return this.jsn.text(BODY);
        }

        public void body(String value) throws IOException {
            this.cmnt.patch(Json.createObjectBuilder().add(BODY, value).build());
        }

        @Override
        public Pull pull() {
            return this.cmnt.pull();
        }

        @Override
        public int number() {
            return this.cmnt.number();
        }

        @Override
        public void react(Reaction reaction) {
            throw new UnsupportedOperationException("React not implemented");
        }

        @Override
        public Collection<Reaction> reactions() {
            throw new UnsupportedOperationException("reactions() not implemented");
        }

        @Override
        public int compareTo(PullComment comment) {
            return this.cmnt.compareTo(comment);
        }

        @Override
        public void patch(JsonObject json) throws IOException {
            this.cmnt.patch(json);
        }

        @Override
        public JsonObject json() throws IOException {
            return this.cmnt.json();
        }

        public String author() throws IOException {
            return this.json().getJsonObject("user").getString("login");
        }

        public String toString() {
            return "PullComment.Smart(cmnt=" + this.cmnt + ", jsn=" + this.jsn + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Smart)) {
                return false;
            }
            Smart other = (Smart)o;
            PullComment this$cmnt = this.cmnt;
            PullComment other$cmnt = other.cmnt;
            if (this$cmnt == null ? other$cmnt != null : !this$cmnt.equals(other$cmnt)) {
                return false;
            }
            SmartJson this$jsn = this.jsn;
            SmartJson other$jsn = other.jsn;
            return !(this$jsn == null ? other$jsn != null : !((Object)this$jsn).equals(other$jsn));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            PullComment $cmnt = this.cmnt;
            result = result * 59 + ($cmnt == null ? 43 : $cmnt.hashCode());
            SmartJson $jsn = this.jsn;
            result = result * 59 + ($jsn == null ? 43 : ((Object)$jsn).hashCode());
            return result;
        }
    }
}

