/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github.mock;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.Coordinates;
import com.jcabi.github.Repo;
import com.jcabi.github.Tag;
import com.jcabi.github.Tags;
import com.jcabi.github.mock.MkReferences;
import com.jcabi.github.mock.MkRepo;
import com.jcabi.github.mock.MkStorage;
import com.jcabi.github.mock.MkTag;
import java.io.IOException;
import java.util.Map;
import javax.json.JsonObject;
import javax.json.JsonValue;
import org.xembly.Directive;
import org.xembly.Directives;

@Immutable
@Loggable(value=1)
final class MkTags
implements Tags {
    private final transient MkStorage storage;
    private final transient String self;
    private final transient Coordinates coords;

    MkTags(MkStorage stg, String login, Coordinates rep) throws IOException {
        this.storage = stg;
        this.self = login;
        this.coords = rep;
        this.storage.apply((Iterable<Directive>)new Directives().xpath((Object)String.format("/github/repos/repo[@coords='%s']/git", this.coords)).addIf((Object)"tags"));
    }

    @Override
    public Repo repo() {
        return new MkRepo(this.storage, this.self, this.coords);
    }

    @Override
    public Tag create(JsonObject params) throws IOException {
        Directives dirs = new Directives().xpath((Object)this.xpath()).add((Object)"tag");
        for (Map.Entry entry : params.entrySet()) {
            dirs.add(entry.getKey()).set((Object)((JsonValue)entry.getValue()).toString()).up();
        }
        this.storage.apply((Iterable<Directive>)dirs);
        new MkReferences(this.storage, this.self, this.coords).create("refs/tags/" + params.getString("name"), params.getString("sha"));
        return this.get(params.getString("sha"));
    }

    @Override
    public Tag get(String sha) {
        return new MkTag(this.storage, this.self, this.coords, sha);
    }

    private String xpath() {
        return String.format("/github/repos/repo[@coords='%s']/git/tags", this.coords);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MkTags)) {
            return false;
        }
        MkTags other = (MkTags)o;
        MkStorage this$storage = this.storage;
        MkStorage other$storage = other.storage;
        if (this$storage == null ? other$storage != null : !this$storage.equals(other$storage)) {
            return false;
        }
        String this$self = this.self;
        String other$self = other.self;
        if (this$self == null ? other$self != null : !this$self.equals(other$self)) {
            return false;
        }
        Coordinates this$coords = this.coords;
        Coordinates other$coords = other.coords;
        return !(this$coords == null ? other$coords != null : !this$coords.equals(other$coords));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MkStorage $storage = this.storage;
        result = result * 59 + ($storage == null ? 43 : $storage.hashCode());
        String $self = this.self;
        result = result * 59 + ($self == null ? 43 : $self.hashCode());
        Coordinates $coords = this.coords;
        result = result * 59 + ($coords == null ? 43 : $coords.hashCode());
        return result;
    }
}

