/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.Gist;
import com.jcabi.github.Gists;
import com.jcabi.github.Github;
import com.jcabi.github.RtGist;
import com.jcabi.github.RtPagination;
import com.jcabi.http.Request;
import com.jcabi.http.response.JsonResponse;
import com.jcabi.http.response.RestResponse;
import java.io.IOException;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonStructure;

@Immutable
@Loggable(value=1)
final class RtGists
implements Gists {
    private final transient Request entry;
    private final transient Github ghub;
    private final transient Request request;

    RtGists(Github github, Request req) {
        this.entry = req;
        this.ghub = github;
        this.request = this.entry.uri().path("/gists").back();
    }

    public String toString() {
        return this.request.uri().get().toString();
    }

    @Override
    public Github github() {
        return this.ghub;
    }

    @Override
    public Gist create(Map<String, String> files, boolean visible) throws IOException {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        for (Map.Entry<String, String> file : files.entrySet()) {
            builder = builder.add(file.getKey(), Json.createObjectBuilder().add("content", file.getValue()));
        }
        JsonObject json = Json.createObjectBuilder().add("files", builder).add("public", visible).build();
        return this.get(((JsonResponse)((RestResponse)this.request.method("POST").body().set((JsonStructure)json).back().fetch().as(RestResponse.class)).assertStatus(201).as(JsonResponse.class)).json().readObject().getString("id"));
    }

    @Override
    public Gist get(String name) {
        return new RtGist(this.ghub, this.entry, name);
    }

    @Override
    public Iterable<Gist> iterate() {
        return new RtPagination<Gist>(this.request, object -> this.get(object.getString("id")));
    }

    @Override
    public void remove(String identifier) throws IOException {
        ((RestResponse)this.request.method("DELETE").uri().path(identifier).back().fetch().as(RestResponse.class)).assertStatus(204);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RtGists)) {
            return false;
        }
        RtGists other = (RtGists)o;
        Github this$ghub = this.ghub;
        Github other$ghub = other.ghub;
        if (this$ghub == null ? other$ghub != null : !this$ghub.equals(other$ghub)) {
            return false;
        }
        Request this$request = this.request;
        Request other$request = other.request;
        return !(this$request == null ? other$request != null : !this$request.equals(other$request));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Github $ghub = this.ghub;
        result = result * 59 + ($ghub == null ? 43 : $ghub.hashCode());
        Request $request = this.request;
        result = result * 59 + ($request == null ? 43 : $request.hashCode());
        return result;
    }
}

