/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.Github;
import com.jcabi.github.JsonPatchable;
import com.jcabi.github.JsonReadable;
import com.jcabi.github.Release;
import com.jcabi.github.SmartJson;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.ParseException;
import java.util.Date;
import javax.json.Json;
import javax.json.JsonObject;

@Immutable
public interface ReleaseAsset
extends JsonReadable,
JsonPatchable {
    public Release release();

    public int number();

    public void remove() throws IOException;

    public InputStream raw() throws IOException;

    @Immutable
    @Loggable(value=1)
    public static final class Smart
    implements ReleaseAsset {
        private final transient ReleaseAsset asset;
        private final transient SmartJson jsn;

        public Smart(ReleaseAsset ast) {
            this.asset = ast;
            this.jsn = new SmartJson(ast);
        }

        public URL url() throws IOException {
            return new URL(this.jsn.text("url"));
        }

        public String name() throws IOException {
            return this.jsn.text("name");
        }

        public String label() throws IOException {
            return this.jsn.text("label");
        }

        public String state() throws IOException {
            return this.jsn.text("state");
        }

        public String contentType() throws IOException {
            return this.jsn.text("content_type");
        }

        public int size() throws IOException {
            return this.jsn.number("size");
        }

        public int downloadCount() throws IOException {
            return this.jsn.number("download_count");
        }

        public Date createdAt() throws IOException {
            try {
                return new Github.Time(this.jsn.text("created_at")).date();
            }
            catch (ParseException ex) {
                throw new IllegalStateException(ex);
            }
        }

        public Date updatedAt() throws IOException {
            try {
                return new Github.Time(this.jsn.text("updated_at")).date();
            }
            catch (ParseException ex) {
                throw new IllegalStateException(ex);
            }
        }

        public void name(String text) throws IOException {
            this.asset.patch(Json.createObjectBuilder().add("name", text).build());
        }

        public void label(String text) throws IOException {
            this.asset.patch(Json.createObjectBuilder().add("label", text).build());
        }

        @Override
        public Release release() {
            return this.asset.release();
        }

        @Override
        public int number() {
            return this.asset.number();
        }

        @Override
        public void remove() throws IOException {
            this.asset.remove();
        }

        @Override
        public InputStream raw() throws IOException {
            return this.asset.raw();
        }

        @Override
        public void patch(JsonObject json) throws IOException {
            this.asset.patch(json);
        }

        @Override
        public JsonObject json() throws IOException {
            return this.asset.json();
        }

        public String toString() {
            return "ReleaseAsset.Smart(asset=" + this.asset + ", jsn=" + this.jsn + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Smart)) {
                return false;
            }
            Smart other = (Smart)o;
            ReleaseAsset this$asset = this.asset;
            ReleaseAsset other$asset = other.asset;
            if (this$asset == null ? other$asset != null : !this$asset.equals(other$asset)) {
                return false;
            }
            SmartJson this$jsn = this.jsn;
            SmartJson other$jsn = other.jsn;
            return !(this$jsn == null ? other$jsn != null : !((Object)this$jsn).equals(other$jsn));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ReleaseAsset $asset = this.asset;
            result = result * 59 + ($asset == null ? 43 : $asset.hashCode());
            SmartJson $jsn = this.jsn;
            result = result * 59 + ($jsn == null ? 43 : ((Object)$jsn).hashCode());
            return result;
        }
    }
}

