/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.Coordinates;
import com.jcabi.github.Repo;
import com.jcabi.github.Stars;
import com.jcabi.http.Request;
import com.jcabi.http.response.RestResponse;
import java.io.IOException;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

@Immutable
@Loggable(value=1)
final class RtStars
implements Stars {
    private final transient Request request;
    private final transient Repo owner;

    RtStars(Request req, Repo repo) {
        Coordinates coords = repo.coordinates();
        this.request = req.uri().path("/user/starred").path(coords.user()).path(coords.repo()).back();
        this.owner = repo;
    }

    @Override
    public Repo repo() {
        return this.owner;
    }

    @Override
    public boolean starred() throws IOException {
        return ((RestResponse)this.request.fetch().as(RestResponse.class)).assertStatus(Matchers.is((Matcher)Matchers.oneOf((Object[])new Integer[]{204, 404}))).status() == 204;
    }

    @Override
    public void star() throws IOException {
        ((RestResponse)this.request.method("PUT").fetch().as(RestResponse.class)).assertStatus(204);
    }

    @Override
    public void unstar() throws IOException {
        ((RestResponse)this.request.method("DELETE").fetch().as(RestResponse.class)).assertStatus(204);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RtStars)) {
            return false;
        }
        RtStars other = (RtStars)o;
        Request this$request = this.request;
        Request other$request = other.request;
        if (this$request == null ? other$request != null : !this$request.equals(other$request)) {
            return false;
        }
        Repo this$owner = this.owner;
        Repo other$owner = other.owner;
        return !(this$owner == null ? other$owner != null : !this$owner.equals(other$owner));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Request $request = this.request;
        result = result * 59 + ($request == null ? 43 : $request.hashCode());
        Repo $owner = this.owner;
        result = result * 59 + ($owner == null ? 43 : $owner.hashCode());
        return result;
    }
}

