/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.Github;
import com.jcabi.github.Markdown;
import com.jcabi.http.Request;
import com.jcabi.http.response.RestResponse;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import javax.json.Json;
import javax.json.JsonObject;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

@Immutable
@Loggable(value=1)
final class RtMarkdown
implements Markdown {
    private final transient Github ghub;
    private final transient Request request;

    RtMarkdown(Github github, Request req) {
        this.ghub = github;
        this.request = req.uri().path("markdown").back().method("POST");
    }

    public String toString() {
        return this.request.uri().get().toString();
    }

    @Override
    public Github github() {
        return this.ghub;
    }

    @Override
    public String render(JsonObject json) throws IOException {
        StringWriter output = new StringWriter();
        Json.createWriter((Writer)output).writeObject(json);
        return ((RestResponse)this.request.body().set(output.toString()).back().fetch().as(RestResponse.class)).assertStatus(200).assertHeader("Content-Type", Matchers.everyItem((Matcher)Matchers.startsWith((String)"text/html"))).body();
    }

    @Override
    public String raw(String text) throws IOException {
        return ((RestResponse)this.request.body().set(text).back().uri().path("raw").back().reset("Content-Type").header("Content-Type", (Object)"text/plain").fetch().as(RestResponse.class)).assertStatus(200).assertHeader("Content-Type", Matchers.everyItem((Matcher)Matchers.startsWith((String)"text/html"))).body();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RtMarkdown)) {
            return false;
        }
        RtMarkdown other = (RtMarkdown)o;
        Github this$ghub = this.ghub;
        Github other$ghub = other.ghub;
        if (this$ghub == null ? other$ghub != null : !this$ghub.equals(other$ghub)) {
            return false;
        }
        Request this$request = this.request;
        Request other$request = other.request;
        return !(this$request == null ? other$request != null : !this$request.equals(other$request));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Github $ghub = this.ghub;
        result = result * 59 + ($ghub == null ? 43 : $ghub.hashCode());
        Request $request = this.request;
        result = result * 59 + ($request == null ? 43 : $request.hashCode());
        return result;
    }
}

