/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.Assignees;
import com.jcabi.github.Branches;
import com.jcabi.github.Collaborators;
import com.jcabi.github.Contents;
import com.jcabi.github.Coordinates;
import com.jcabi.github.DeployKeys;
import com.jcabi.github.Existence;
import com.jcabi.github.Forks;
import com.jcabi.github.Git;
import com.jcabi.github.Github;
import com.jcabi.github.Hooks;
import com.jcabi.github.IssueEvents;
import com.jcabi.github.Issues;
import com.jcabi.github.JsonPatchable;
import com.jcabi.github.JsonReadable;
import com.jcabi.github.Labels;
import com.jcabi.github.Language;
import com.jcabi.github.Milestones;
import com.jcabi.github.Notifications;
import com.jcabi.github.Pulls;
import com.jcabi.github.Releases;
import com.jcabi.github.RepoCommits;
import com.jcabi.github.SmartJson;
import com.jcabi.github.Stars;
import java.io.IOException;
import javax.json.JsonObject;
import javax.json.JsonValue;

@Immutable
public interface Repo
extends JsonReadable,
JsonPatchable,
Comparable<Repo> {
    public Github github();

    public Coordinates coordinates();

    public Issues issues();

    public Milestones milestones();

    public Pulls pulls();

    public Hooks hooks();

    public IssueEvents issueEvents();

    public Labels labels();

    public Assignees assignees();

    public Releases releases();

    public DeployKeys keys();

    public Forks forks();

    public RepoCommits commits();

    public Branches branches();

    public Contents contents();

    public Collaborators collaborators();

    public Git git();

    public Stars stars();

    public Notifications notifications();

    public Iterable<Language> languages() throws IOException;

    @Immutable
    @Loggable(value=1)
    public static final class Smart
    implements Repo {
        private final transient Repo repo;
        private final transient SmartJson jsn;

        public Smart(Repo rep) {
            this.repo = rep;
            this.jsn = new SmartJson(rep);
        }

        public boolean exists() throws IOException {
            return new Existence(this.repo).check();
        }

        public boolean hasDescription() throws IOException {
            return this.jsn.hasNotNull("description");
        }

        public String description() throws IOException {
            return this.jsn.text("description");
        }

        public boolean isPrivate() throws IOException {
            return Boolean.parseBoolean(((JsonValue)this.json().getOrDefault((Object)"private", (Object)JsonValue.FALSE)).toString().replace("\"", ""));
        }

        @Override
        public Github github() {
            return this.repo.github();
        }

        @Override
        public Coordinates coordinates() {
            return this.repo.coordinates();
        }

        @Override
        public Issues issues() {
            return this.repo.issues();
        }

        @Override
        public Milestones milestones() {
            return this.repo.milestones();
        }

        @Override
        public Pulls pulls() {
            return this.repo.pulls();
        }

        @Override
        public Hooks hooks() {
            return this.repo.hooks();
        }

        @Override
        public IssueEvents issueEvents() {
            return this.repo.issueEvents();
        }

        @Override
        public Labels labels() {
            return this.repo.labels();
        }

        @Override
        public Assignees assignees() {
            return this.repo.assignees();
        }

        @Override
        public Releases releases() {
            return this.repo.releases();
        }

        @Override
        public DeployKeys keys() {
            return this.repo.keys();
        }

        @Override
        public Forks forks() {
            return this.repo.forks();
        }

        @Override
        public Contents contents() {
            return this.repo.contents();
        }

        @Override
        public Collaborators collaborators() {
            return this.repo.collaborators();
        }

        @Override
        public Git git() {
            return this.repo.git();
        }

        @Override
        public Stars stars() {
            return this.repo.stars();
        }

        @Override
        public Notifications notifications() {
            return this.repo.notifications();
        }

        @Override
        public Iterable<Language> languages() throws IOException {
            return this.repo.languages();
        }

        @Override
        public void patch(JsonObject json) throws IOException {
            this.repo.patch(json);
        }

        @Override
        public RepoCommits commits() {
            return this.repo.commits();
        }

        @Override
        public Branches branches() {
            return this.repo.branches();
        }

        @Override
        public JsonObject json() throws IOException {
            return this.repo.json();
        }

        @Override
        public int compareTo(Repo repos) {
            return this.repo.compareTo(repos);
        }

        public String toString() {
            return "Repo.Smart(repo=" + this.repo + ", jsn=" + this.jsn + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Smart)) {
                return false;
            }
            Smart other = (Smart)o;
            Repo this$repo = this.repo;
            Repo other$repo = other.repo;
            if (this$repo == null ? other$repo != null : !this$repo.equals(other$repo)) {
                return false;
            }
            SmartJson this$jsn = this.jsn;
            SmartJson other$jsn = other.jsn;
            return !(this$jsn == null ? other$jsn != null : !((Object)this$jsn).equals(other$jsn));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Repo $repo = this.repo;
            result = result * 59 + ($repo == null ? 43 : $repo.hashCode());
            SmartJson $jsn = this.jsn;
            result = result * 59 + ($jsn == null ? 43 : ((Object)$jsn).hashCode());
            return result;
        }
    }
}

