/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github.safe;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.Comments;
import com.jcabi.github.Event;
import com.jcabi.github.Issue;
import com.jcabi.github.IssueLabels;
import com.jcabi.github.Reaction;
import com.jcabi.github.Repo;
import com.jcabi.github.mock.MkGithub;
import com.jcabi.github.safe.SfComments;
import com.jcabi.log.Logger;
import java.io.IOException;
import javax.json.JsonObject;

@Immutable
@Loggable(value=1)
public final class SfIssue
implements Issue {
    private final transient Issue origin;

    public SfIssue(Issue issue) {
        this.origin = issue;
    }

    public String toString() {
        return this.origin.toString();
    }

    @Override
    public JsonObject json() throws IOException {
        JsonObject json;
        try {
            json = this.origin.json();
        }
        catch (AssertionError ex) {
            json = new MkGithub().randomRepo().issues().create("", "").json();
            Logger.warn((Object)this, (String)"failed to fetch issue: %[exception]s", (Object[])new Object[]{ex});
        }
        return json;
    }

    @Override
    public void patch(JsonObject json) throws IOException {
        try {
            this.origin.patch(json);
        }
        catch (AssertionError ex) {
            Logger.warn((Object)this, (String)"failed to patch issue: %[exception]s", (Object[])new Object[]{ex});
        }
    }

    @Override
    public Repo repo() {
        return this.origin.repo();
    }

    @Override
    public int number() {
        return this.origin.number();
    }

    @Override
    public Comments comments() {
        return new SfComments(this.origin.comments());
    }

    @Override
    public IssueLabels labels() {
        return this.origin.labels();
    }

    @Override
    public Iterable<Event> events() throws IOException {
        return this.origin.events();
    }

    @Override
    public boolean exists() throws IOException {
        return this.origin.exists();
    }

    @Override
    public int compareTo(Issue issue) {
        return this.origin.compareTo(issue);
    }

    @Override
    public void react(Reaction reaction) throws IOException {
        this.origin.react(reaction);
    }

    @Override
    public Iterable<Reaction> reactions() {
        return this.origin.reactions();
    }

    @Override
    public void lock(String reason) {
        this.origin.lock(reason);
    }

    @Override
    public void unlock() {
        this.origin.unlock();
    }

    @Override
    public boolean isLocked() {
        return this.origin.isLocked();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SfIssue)) {
            return false;
        }
        SfIssue other = (SfIssue)o;
        Issue this$origin = this.origin;
        Issue other$origin = other.origin;
        return !(this$origin == null ? other$origin != null : !this$origin.equals(other$origin));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Issue $origin = this.origin;
        result = result * 59 + ($origin == null ? 43 : $origin.hashCode());
        return result;
    }
}

