/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.Github;
import com.jcabi.github.Organization;
import com.jcabi.github.PublicMembers;
import com.jcabi.github.RtJson;
import com.jcabi.github.RtPublicMembers;
import com.jcabi.http.Request;
import java.io.IOException;
import javax.json.JsonObject;

@Immutable
@Loggable(value=1)
final class RtOrganization
implements Organization {
    private final transient Github ghub;
    private final transient Request entry;
    private final transient Request request;
    private final transient String self;

    public RtOrganization(Github github, Request req, String login) {
        this.ghub = github;
        this.entry = req;
        this.request = req.uri().path("/orgs").path(login).back();
        this.self = login;
    }

    public String toString() {
        return this.request.uri().get().toString();
    }

    @Override
    public Github github() {
        return this.ghub;
    }

    @Override
    public String login() {
        return this.self;
    }

    @Override
    public PublicMembers publicMembers() {
        return new RtPublicMembers(this.entry, this);
    }

    @Override
    public int compareTo(Organization other) {
        return this.login().compareTo(other.login());
    }

    @Override
    public void patch(JsonObject json) throws IOException {
        new RtJson(this.request).patch(json);
    }

    @Override
    public JsonObject json() throws IOException {
        return new RtJson(this.request).fetch();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RtOrganization)) {
            return false;
        }
        RtOrganization other = (RtOrganization)o;
        Github this$ghub = this.ghub;
        Github other$ghub = other.ghub;
        if (this$ghub == null ? other$ghub != null : !this$ghub.equals(other$ghub)) {
            return false;
        }
        Request this$request = this.request;
        Request other$request = other.request;
        return !(this$request == null ? other$request != null : !this$request.equals(other$request));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Github $ghub = this.ghub;
        result = result * 59 + ($ghub == null ? 43 : $ghub.hashCode());
        Request $request = this.request;
        result = result * 59 + ($request == null ? 43 : $request.hashCode());
        return result;
    }
}

