/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github.mock;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.Coordinates;
import com.jcabi.github.Label;
import com.jcabi.github.Labels;
import com.jcabi.github.Repo;
import com.jcabi.github.mock.MkIterable;
import com.jcabi.github.mock.MkLabel;
import com.jcabi.github.mock.MkRepo;
import com.jcabi.github.mock.MkStorage;
import com.jcabi.xml.XML;
import java.io.IOException;
import org.xembly.Directive;
import org.xembly.Directives;

@Immutable
@Loggable(value=1)
final class MkLabels
implements Labels {
    private final transient MkStorage storage;
    private final transient String self;
    private final transient Coordinates coords;

    MkLabels(MkStorage stg, String login, Coordinates rep) throws IOException {
        this.storage = stg;
        this.self = login;
        this.coords = rep;
        this.storage.apply((Iterable<Directive>)new Directives().xpath((Object)String.format("/github/repos/repo[@coords='%s']", this.coords)).addIf((Object)"labels"));
    }

    @Override
    public Repo repo() {
        return new MkRepo(this.storage, this.self, this.coords);
    }

    @Override
    public Label get(String name) {
        return new MkLabel(this.storage, this.self, this.coords, name);
    }

    @Override
    public Label create(String name, String color) throws IOException {
        if (!color.matches("[0-9a-f]{6}")) {
            throw new IllegalArgumentException(String.format("color '%s' is in wrong format, six hex letters expected", color));
        }
        this.storage.apply((Iterable<Directive>)new Directives().xpath((Object)this.xpath()).add((Object)"label").add((Object)"name").set((Object)name).up().add((Object)"color").set((Object)color).up());
        return this.get(name);
    }

    @Override
    public Iterable<Label> iterate() {
        return new MkIterable<Label>(this.storage, String.format("%s/label", this.xpath()), new MkIterable.Mapping<Label>(){

            @Override
            public Label map(XML xml) {
                return MkLabels.this.get((String)xml.xpath("name/text()").get(0));
            }
        });
    }

    @Override
    public void delete(String name) throws IOException {
        this.storage.apply((Iterable<Directive>)new Directives().xpath((Object)this.xpath()).xpath((Object)String.format("label[name='%s']", name)).remove().xpath((Object)"/github/repos").xpath((Object)String.format("repo[@coords='%s']", this.coords)).xpath((Object)String.format("issues/issue/labels/label[.='%s']", name)).remove());
    }

    private String xpath() {
        return String.format("/github/repos/repo[@coords='%s']/labels", this.coords);
    }

    public String toString() {
        return "MkLabels(storage=" + this.storage + ", self=" + this.self + ", coords=" + this.coords + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MkLabels)) {
            return false;
        }
        MkLabels other = (MkLabels)o;
        MkStorage this$storage = this.storage;
        MkStorage other$storage = other.storage;
        if (this$storage == null ? other$storage != null : !this$storage.equals(other$storage)) {
            return false;
        }
        String this$self = this.self;
        String other$self = other.self;
        if (this$self == null ? other$self != null : !this$self.equals(other$self)) {
            return false;
        }
        Coordinates this$coords = this.coords;
        Coordinates other$coords = other.coords;
        return !(this$coords == null ? other$coords != null : !this$coords.equals(other$coords));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MkStorage $storage = this.storage;
        result = result * 59 + ($storage == null ? 43 : $storage.hashCode());
        String $self = this.self;
        result = result * 59 + ($self == null ? 43 : $self.hashCode());
        Coordinates $coords = this.coords;
        result = result * 59 + ($coords == null ? 43 : $coords.hashCode());
        return result;
    }
}

