/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github.wire;

import com.jcabi.aspects.Immutable;
import com.jcabi.http.Request;
import com.jcabi.http.Response;
import com.jcabi.http.Wire;
import com.jcabi.log.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import lombok.Generated;

@Immutable
public final class CarefulWire
implements Wire {
    private final transient Wire origin;
    private final transient int threshold;

    public CarefulWire(Wire wire, int thrshld) {
        this.origin = wire;
        this.threshold = thrshld;
    }

    public Response send(Request req, String home, String method, Collection<Map.Entry<String, String>> headers, InputStream content, int connect, int read) throws IOException {
        long now;
        long reset;
        Response resp = this.origin.send(req, home, method, headers, content, connect, read);
        int remaining = CarefulWire.remainingHeader(resp);
        if (remaining < this.threshold && (reset = CarefulWire.resetHeader(resp)) > (now = TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis()))) {
            long length = reset - now;
            Logger.info((Object)this, (String)"Remaining number of requests per hour is less than %d. Waiting for %d seconds.", (Object[])new Object[]{this.threshold, length});
            try {
                TimeUnit.SECONDS.sleep(length);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                throw new IllegalStateException(ex);
            }
        }
        return resp;
    }

    private static String headerOrNull(Response resp, String headername) {
        List values = (List)resp.headers().get(headername);
        String value = null;
        if (values != null && !values.isEmpty()) {
            value = (String)values.get(0);
        }
        return value;
    }

    private static int remainingHeader(Response resp) {
        String remainingstr = CarefulWire.headerOrNull(resp, "X-RateLimit-Remaining");
        int remaining = Integer.MAX_VALUE;
        if (remainingstr != null) {
            remaining = Integer.parseInt(remainingstr);
        }
        return remaining;
    }

    private static long resetHeader(Response resp) {
        String resetstr = CarefulWire.headerOrNull(resp, "X-RateLimit-Reset");
        long reset = 0L;
        if (resetstr != null) {
            reset = Long.parseLong(resetstr);
        }
        return reset;
    }

    @Generated
    public String toString() {
        return "CarefulWire(origin=" + this.origin + ", threshold=" + this.threshold + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CarefulWire)) {
            return false;
        }
        CarefulWire other = (CarefulWire)o;
        if (this.threshold != other.threshold) {
            return false;
        }
        Wire this$origin = this.origin;
        Wire other$origin = other.origin;
        return !(this$origin == null ? other$origin != null : !this$origin.equals(other$origin));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.threshold;
        Wire $origin = this.origin;
        result = result * 59 + ($origin == null ? 43 : $origin.hashCode());
        return result;
    }
}

