/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github.mock;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.Repo;
import com.jcabi.github.RepoCommit;
import com.jcabi.github.mock.JsonNode;
import com.jcabi.github.mock.MkStorage;
import com.jcabi.xml.XML;
import jakarta.json.JsonObject;
import java.io.IOException;
import lombok.Generated;
import org.apache.commons.lang3.builder.CompareToBuilder;

@Immutable
@Loggable(value=1)
final class MkRepoCommit
implements RepoCommit {
    private final transient String hash;
    private final transient MkStorage storage;
    private final transient Repo repository;

    MkRepoCommit(MkStorage stg, Repo repo, String sha) {
        this.storage = stg;
        this.repository = repo;
        this.hash = sha;
    }

    @Override
    public int compareTo(RepoCommit other) {
        return new CompareToBuilder().append((Object)this.repo().coordinates(), (Object)other.repo().coordinates()).append((Object)this.sha(), (Object)other.sha()).build();
    }

    @Override
    public JsonObject json() throws IOException {
        return new JsonNode((XML)this.storage.xml().nodes(String.format("/github/repos/repo[@coords='%s']/commits/commit[sha='%s']", this.repo().coordinates(), this.hash)).get(0)).json();
    }

    @Override
    public Repo repo() {
        return this.repository;
    }

    @Override
    public String sha() {
        return this.hash;
    }

    @Generated
    public String toString() {
        return "MkRepoCommit(hash=" + this.hash + ", storage=" + this.storage + ", repository=" + this.repository + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MkRepoCommit)) {
            return false;
        }
        MkRepoCommit other = (MkRepoCommit)o;
        String this$hash = this.hash;
        String other$hash = other.hash;
        if (this$hash == null ? other$hash != null : !this$hash.equals(other$hash)) {
            return false;
        }
        Repo this$repository = this.repository;
        Repo other$repository = other.repository;
        return !(this$repository == null ? other$repository != null : !this$repository.equals(other$repository));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $hash = this.hash;
        result = result * 59 + ($hash == null ? 43 : $hash.hashCode());
        Repo $repository = this.repository;
        result = result * 59 + ($repository == null ? 43 : $repository.hashCode());
        return result;
    }
}

