/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github.mock;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.Coordinates;
import com.jcabi.github.Event;
import com.jcabi.github.Repo;
import com.jcabi.github.mock.JsonNode;
import com.jcabi.github.mock.MkRepo;
import com.jcabi.github.mock.MkStorage;
import com.jcabi.xml.XML;
import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import java.io.IOException;
import lombok.Generated;

@Immutable
@Loggable(value=1)
final class MkEvent
implements Event {
    private static final String CREATED_AT = "created_at";
    private static final String EVENT = "event";
    private static final String LOGIN = "login";
    private final transient MkStorage storage;
    private final transient String self;
    private final transient Coordinates coords;
    private final transient int num;

    MkEvent(MkStorage stg, String login, Coordinates rep, int nmbr) {
        this.storage = stg;
        this.self = login;
        this.coords = rep;
        this.num = nmbr;
    }

    @Override
    public Repo repo() {
        return new MkRepo(this.storage, this.self, this.coords);
    }

    @Override
    public int number() {
        return this.num;
    }

    @Override
    public int compareTo(Event event) {
        throw new UnsupportedOperationException("#compareTo()");
    }

    @Override
    public JsonObject json() throws IOException {
        JsonObject obj = new JsonNode((XML)this.storage.xml().nodes(this.xpath()).get(0)).json();
        JsonObjectBuilder builder = Json.createObjectBuilder().add("id", this.num).add("url", String.format("https://api.jcabi-github.invalid/repos/%s/issues/events/%s", this.coords, this.num)).add("commit_id", JsonValue.NULL).add(EVENT, obj.getString(EVENT)).add("actor", (JsonValue)Json.createObjectBuilder().add(LOGIN, obj.getString(LOGIN)).build()).add(CREATED_AT, obj.getString(CREATED_AT));
        String label = "label";
        if (obj.containsKey((Object)"label")) {
            builder = builder.add("label", (JsonValue)Json.createObjectBuilder().add("name", obj.getString("label")).build());
        }
        return builder.build();
    }

    public boolean equals(Object obj) {
        boolean result;
        if (this == obj) {
            result = true;
        } else if (obj == null || this.getClass() != obj.getClass()) {
            result = false;
        } else {
            MkEvent other = (MkEvent)obj;
            result = this.num == other.num && this.storage.equals(other.storage) && this.self.equals(other.self) && this.coords.equals(other.coords);
        }
        return result;
    }

    public int hashCode() {
        int result = this.storage.hashCode();
        result = 31 * result + this.self.hashCode();
        result = 31 * result + this.coords.hashCode();
        result = 31 * result + this.num;
        return result;
    }

    private String xpath() {
        return String.format("/github/repos/repo[@coords='%s']/issue-events/issue-event[number='%d']", this.coords, this.num);
    }

    @Generated
    public String toString() {
        return "MkEvent(storage=" + this.storage + ", self=" + this.self + ", coords=" + this.coords + ", num=" + this.num + ")";
    }
}

