/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github.mock;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.Comment;
import com.jcabi.github.Comments;
import com.jcabi.github.Coordinates;
import com.jcabi.github.GitHub;
import com.jcabi.github.Issue;
import com.jcabi.github.mock.MkComment;
import com.jcabi.github.mock.MkIssue;
import com.jcabi.github.mock.MkIterable;
import com.jcabi.github.mock.MkStorage;
import com.jcabi.log.Logger;
import java.io.IOException;
import java.util.Date;
import lombok.Generated;
import org.xembly.Directive;
import org.xembly.Directives;

@Immutable
@Loggable(value=1)
final class MkComments
implements Comments {
    private static final String COMMENT_PATH = "/comment";
    private static final String COMMENT_NUM_XPATH = "//comment/number";
    private final transient MkStorage storage;
    private final transient String self;
    private final transient Coordinates repo;
    private final transient int ticket;

    MkComments(MkStorage stg, String login, Coordinates rep, int issue) throws IOException {
        this.storage = stg;
        this.self = login;
        this.repo = rep;
        this.ticket = issue;
        this.storage.apply((Iterable<Directive>)new Directives().xpath((Object)String.format("/github/repos/repo[@coords='%s']/issues/issue[number='%d']", this.repo, this.ticket)).addIf((Object)"comments"));
    }

    @Override
    public Issue issue() {
        return new MkIssue(this.storage, this.self, this.repo, this.ticket);
    }

    @Override
    public Comment get(long number) {
        return new MkComment(this.storage, this.self, this.repo, this.ticket, number);
    }

    @Override
    public Iterable<Comment> iterate(Date since) {
        return new MkIterable<Comment>(this.storage, this.xpath().concat(COMMENT_PATH), xml -> this.get(Long.parseLong((String)xml.xpath("number/text()").get(0))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Comment post(String text) throws IOException {
        long number;
        this.storage.lock();
        try {
            String timestamp = new GitHub.Time().toString();
            number = 1 + this.storage.xml().nodes(COMMENT_NUM_XPATH).size();
            this.storage.apply((Iterable<Directive>)new Directives().xpath((Object)this.xpath()).add((Object)"comment").add((Object)"number").set((Object)Long.toString(number)).up().add((Object)"url").set((Object)String.format("https://api.jcabi-github.invalid/repos/%s/%s/issues/comments/%d", this.repo.user(), this.repo.repo(), number)).up().add((Object)"body").set((Object)text).up().add((Object)"user").add((Object)"login").set((Object)this.self).up().up().add((Object)"created_at").set((Object)timestamp).up().add((Object)"updated_at").set((Object)timestamp));
        }
        finally {
            this.storage.unlock();
        }
        Logger.info((Object)this, (String)"comment #%d posted to issue #%d by %s: %[text]s", (Object[])new Object[]{number, this.issue().number(), this.self, text});
        return this.get(number);
    }

    private String xpath() {
        return String.format("/github/repos/repo[@coords='%s']/issues/issue[number='%d']/comments", this.repo, this.ticket);
    }

    @Generated
    public String toString() {
        return "MkComments(storage=" + this.storage + ", self=" + this.self + ", repo=" + this.repo + ", ticket=" + this.ticket + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MkComments)) {
            return false;
        }
        MkComments other = (MkComments)o;
        if (this.ticket != other.ticket) {
            return false;
        }
        MkStorage this$storage = this.storage;
        MkStorage other$storage = other.storage;
        if (this$storage == null ? other$storage != null : !this$storage.equals(other$storage)) {
            return false;
        }
        String this$self = this.self;
        String other$self = other.self;
        if (this$self == null ? other$self != null : !this$self.equals(other$self)) {
            return false;
        }
        Coordinates this$repo = this.repo;
        Coordinates other$repo = other.repo;
        return !(this$repo == null ? other$repo != null : !this$repo.equals(other$repo));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.ticket;
        MkStorage $storage = this.storage;
        result = result * 59 + ($storage == null ? 43 : $storage.hashCode());
        String $self = this.self;
        result = result * 59 + ($self == null ? 43 : $self.hashCode());
        Coordinates $repo = this.repo;
        result = result * 59 + ($repo == null ? 43 : $repo.hashCode());
        return result;
    }
}

