/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.Repo;
import com.jcabi.github.RtReferences;
import com.jcabi.github.RtTag;
import com.jcabi.github.Tag;
import com.jcabi.github.Tags;
import com.jcabi.http.Request;
import com.jcabi.http.response.JsonResponse;
import com.jcabi.http.response.RestResponse;
import jakarta.json.JsonObject;
import jakarta.json.JsonStructure;
import java.io.IOException;
import lombok.Generated;

@Immutable
@Loggable(value=1)
final class RtTags
implements Tags {
    private final transient Request entry;
    private final transient Request request;
    private final transient Repo owner;

    RtTags(Request req, Repo repo) {
        this.entry = req;
        this.owner = repo;
        this.request = req.uri().path("/repos").path(repo.coordinates().user()).path(repo.coordinates().repo()).path("/git").path("/tags").back();
    }

    @Override
    public Repo repo() {
        return this.owner;
    }

    @Override
    public Tag create(JsonObject params) throws IOException {
        Tag created = this.get(((JsonResponse)((RestResponse)this.request.method("POST").body().set((JsonStructure)params).back().fetch().as(RestResponse.class)).assertStatus(201).as(JsonResponse.class)).json().readObject().getString("sha"));
        new RtReferences(this.entry, this.owner).create("refs/tags/" + params.getString("tag"), created.key());
        return created;
    }

    @Override
    public Tag get(String sha) {
        return new RtTag(this.entry, this.owner, sha);
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RtTags)) {
            return false;
        }
        RtTags other = (RtTags)o;
        Request this$entry = this.entry;
        Request other$entry = other.entry;
        if (this$entry == null ? other$entry != null : !this$entry.equals(other$entry)) {
            return false;
        }
        Request this$request = this.request;
        Request other$request = other.request;
        if (this$request == null ? other$request != null : !this$request.equals(other$request)) {
            return false;
        }
        Repo this$owner = this.owner;
        Repo other$owner = other.owner;
        return !(this$owner == null ? other$owner != null : !this$owner.equals(other$owner));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Request $entry = this.entry;
        result = result * 59 + ($entry == null ? 43 : $entry.hashCode());
        Request $request = this.request;
        result = result * 59 + ($request == null ? 43 : $request.hashCode());
        Repo $owner = this.owner;
        result = result * 59 + ($owner == null ? 43 : $owner.hashCode());
        return result;
    }
}

