/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.Organization;
import com.jcabi.github.PublicMembers;
import com.jcabi.github.RtPagination;
import com.jcabi.github.RtUser;
import com.jcabi.github.User;
import com.jcabi.http.Request;
import com.jcabi.http.response.RestResponse;
import java.io.IOException;
import lombok.Generated;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

@Immutable
@Loggable(value=1)
public final class RtPublicMembers
implements PublicMembers {
    private final transient Request entry;
    private final transient Request request;
    private final transient Organization organization;

    public RtPublicMembers(Request req, Organization organ) {
        this.entry = req;
        this.request = req.uri().path("/orgs").path(organ.login()).path("public_members").back();
        this.organization = organ;
    }

    @Override
    public Organization org() {
        return this.organization;
    }

    @Override
    public void conceal(User user) throws IOException {
        ((RestResponse)this.request.uri().path(user.login()).back().method("DELETE").fetch().as(RestResponse.class)).assertStatus(204);
    }

    @Override
    public void publicize(User user) throws IOException {
        ((RestResponse)this.request.uri().path(user.login()).back().method("PUT").fetch().as(RestResponse.class)).assertStatus(204);
    }

    @Override
    public Iterable<User> iterate() {
        return new RtPagination<User>(this.request, object -> new RtUser(this.organization.github(), this.entry, object.getString("login")));
    }

    @Override
    public boolean contains(User user) throws IOException {
        return ((RestResponse)this.request.uri().path(user.login()).back().method("GET").fetch().as(RestResponse.class)).assertStatus(Matchers.is((Matcher)Matchers.oneOf((Object[])new Integer[]{204, 404}))).status() == 204;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RtPublicMembers)) {
            return false;
        }
        RtPublicMembers other = (RtPublicMembers)o;
        Request this$entry = this.entry;
        Request other$entry = other.entry;
        if (this$entry == null ? other$entry != null : !this$entry.equals(other$entry)) {
            return false;
        }
        Organization this$organization = this.organization;
        Organization other$organization = other.organization;
        return !(this$organization == null ? other$organization != null : !this$organization.equals(other$organization));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Request $entry = this.entry;
        result = result * 59 + ($entry == null ? 43 : $entry.hashCode());
        Organization $organization = this.organization;
        result = result * 59 + ($organization == null ? 43 : $organization.hashCode());
        return result;
    }
}

