/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.GitHub;
import com.jcabi.github.Markdown;
import com.jcabi.http.Request;
import com.jcabi.http.response.RestResponse;
import jakarta.json.Json;
import jakarta.json.JsonObject;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import lombok.Generated;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

@Immutable
@Loggable(value=1)
final class RtMarkdown
implements Markdown {
    private final transient GitHub ghub;
    private final transient Request request;

    RtMarkdown(GitHub github, Request req) {
        this.ghub = github;
        this.request = req.uri().path("markdown").back().method("POST");
    }

    public String toString() {
        return this.request.uri().get().toString();
    }

    @Override
    public GitHub github() {
        return this.ghub;
    }

    @Override
    public String render(JsonObject json) throws IOException {
        StringWriter output = new StringWriter();
        Json.createWriter((Writer)output).writeObject(json);
        return ((RestResponse)this.request.body().set(output.toString()).back().fetch().as(RestResponse.class)).assertStatus(200).assertHeader("Content-Type", Matchers.everyItem((Matcher)Matchers.startsWith((String)"text/html"))).body();
    }

    @Override
    public String raw(String text) throws IOException {
        return ((RestResponse)this.request.body().set(text).back().uri().path("raw").back().reset("Content-Type").header("Content-Type", (Object)"text/plain").fetch().as(RestResponse.class)).assertStatus(200).assertHeader("Content-Type", Matchers.everyItem((Matcher)Matchers.startsWith((String)"text/html"))).body();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RtMarkdown)) {
            return false;
        }
        RtMarkdown other = (RtMarkdown)o;
        GitHub this$ghub = this.ghub;
        GitHub other$ghub = other.ghub;
        if (this$ghub == null ? other$ghub != null : !this$ghub.equals(other$ghub)) {
            return false;
        }
        Request this$request = this.request;
        Request other$request = other.request;
        return !(this$request == null ? other$request != null : !this$request.equals(other$request));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        GitHub $ghub = this.ghub;
        result = result * 59 + ($ghub == null ? 43 : $ghub.hashCode());
        Request $request = this.request;
        result = result * 59 + ($request == null ? 43 : $request.hashCode());
        return result;
    }
}

