/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.Collaborators;
import com.jcabi.github.Coordinates;
import com.jcabi.github.Repo;
import com.jcabi.github.RtPagination;
import com.jcabi.github.User;
import com.jcabi.http.Request;
import com.jcabi.http.response.JsonResponse;
import com.jcabi.http.response.RestResponse;
import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.json.JsonStructure;
import java.io.IOException;
import java.util.Locale;
import lombok.Generated;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

@Immutable
@Loggable(value=1)
final class RtCollaborators
implements Collaborators {
    private final transient Request entry;
    private final transient Request request;
    private final transient Repo owner;

    RtCollaborators(Request req, Repo repo) {
        this.entry = req;
        Coordinates coords = repo.coordinates();
        this.request = this.entry.uri().path("/repos").path(coords.user()).path(coords.repo()).path("/collaborators").back();
        this.owner = repo;
    }

    @Override
    public Repo repo() {
        return this.owner;
    }

    @Override
    public boolean isCollaborator(String user) throws IOException {
        return ((RestResponse)this.request.method("GET").uri().path(user).back().fetch().as(RestResponse.class)).assertStatus(Matchers.is((Matcher)Matchers.oneOf((Object[])new Integer[]{204, 404}))).status() == 204;
    }

    @Override
    public void add(String user) throws IOException {
        ((RestResponse)this.request.method("PUT").uri().path(user).back().fetch().as(RestResponse.class)).assertStatus(Matchers.is((Matcher)Matchers.oneOf((Object[])new Integer[]{204, 201})));
    }

    @Override
    public void addWithPermission(String user, Collaborators.Permission permission) throws IOException {
        JsonObject obj = Json.createObjectBuilder().add("permission", permission.toString().toLowerCase(Locale.ENGLISH)).build();
        ((RestResponse)this.request.method("PUT").body().set((JsonStructure)obj).back().fetch().as(RestResponse.class)).assertStatus(201);
    }

    @Override
    public String permission(String user) throws IOException {
        return ((JsonResponse)((RestResponse)this.request.method("GET").uri().path(user).path("permission").back().fetch().as(RestResponse.class)).assertStatus(200).as(JsonResponse.class)).json().readObject().getString("permission");
    }

    @Override
    public void remove(String user) throws IOException {
        ((RestResponse)this.request.method("DELETE").uri().path(user).back().fetch().as(RestResponse.class)).assertStatus(204);
    }

    @Override
    public Iterable<User> iterate() {
        return new RtPagination<User>(this.request, object -> this.owner.github().users().get(object.getString("login")));
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RtCollaborators)) {
            return false;
        }
        RtCollaborators other = (RtCollaborators)o;
        Request this$entry = this.entry;
        Request other$entry = other.entry;
        if (this$entry == null ? other$entry != null : !this$entry.equals(other$entry)) {
            return false;
        }
        Request this$request = this.request;
        Request other$request = other.request;
        if (this$request == null ? other$request != null : !this$request.equals(other$request)) {
            return false;
        }
        Repo this$owner = this.owner;
        Repo other$owner = other.owner;
        return !(this$owner == null ? other$owner != null : !this$owner.equals(other$owner));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Request $entry = this.entry;
        result = result * 59 + ($entry == null ? 43 : $entry.hashCode());
        Request $request = this.request;
        result = result * 59 + ($request == null ? 43 : $request.hashCode());
        Repo $owner = this.owner;
        result = result * 59 + ($owner == null ? 43 : $owner.hashCode());
        return result;
    }
}

