/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.GitHub;
import com.jcabi.github.JsonPatchable;
import com.jcabi.github.JsonReadable;
import com.jcabi.github.ReleaseAssets;
import com.jcabi.github.Repo;
import com.jcabi.github.SmartJson;
import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.ParseException;
import java.util.Date;
import lombok.Generated;

@Immutable
public interface Release
extends JsonReadable,
JsonPatchable {
    public Repo repo();

    public int number();

    public void delete() throws IOException;

    public ReleaseAssets assets();

    @Immutable
    @Loggable(value=1)
    public static final class Smart
    implements Release {
        private final transient Release release;
        private final transient SmartJson jsn;

        public Smart(Release original) {
            this.release = original;
            this.jsn = new SmartJson(original);
        }

        @Override
        public JsonObject json() throws IOException {
            return this.release.json();
        }

        @Override
        public void patch(JsonObject json) throws IOException {
            this.release.patch(json);
        }

        @Override
        public Repo repo() {
            return this.release.repo();
        }

        @Override
        public int number() {
            return this.release.number();
        }

        @Override
        public ReleaseAssets assets() {
            return this.release.assets();
        }

        public URL url() throws IOException {
            try {
                return new URI(this.jsn.text("url")).toURL();
            }
            catch (URISyntaxException ex) {
                throw new IllegalArgumentException(ex);
            }
        }

        public URL htmlUrl() throws IOException {
            try {
                return new URI(this.jsn.text("html_url")).toURL();
            }
            catch (URISyntaxException ex) {
                throw new IllegalArgumentException(ex);
            }
        }

        public URL assetsUrl() throws IOException {
            try {
                return new URI(this.jsn.text("assets_url")).toURL();
            }
            catch (URISyntaxException ex) {
                throw new IllegalArgumentException(ex);
            }
        }

        public URL uploadUrl() throws IOException {
            try {
                return new URI(this.jsn.text("upload_url")).toURL();
            }
            catch (URISyntaxException ex) {
                throw new IllegalArgumentException(ex);
            }
        }

        public String tag() throws IOException {
            return this.jsn.text("tag_name");
        }

        public boolean hasTag() throws IOException {
            return this.jsn.hasNotNull("tag_name");
        }

        public void tag(String text) throws IOException {
            this.release.patch(Json.createObjectBuilder().add("tag_name", text).build());
        }

        public String commitish() throws IOException {
            return this.jsn.text("target_commitish");
        }

        public void commitish(String text) throws IOException {
            this.release.patch(Json.createObjectBuilder().add("target_commitish", text).build());
        }

        public boolean hasName() throws IOException {
            return this.jsn.hasNotNull("name");
        }

        public String name() throws IOException {
            return this.jsn.text("name");
        }

        public void name(String text) throws IOException {
            this.release.patch(Json.createObjectBuilder().add("name", text).build());
        }

        public boolean hasBody() throws IOException {
            return this.jsn.hasNotNull("body");
        }

        public String body() throws IOException {
            String body = this.hasBody() ? this.jsn.text("body") : "";
            return body;
        }

        public void body(String text) throws IOException {
            this.release.patch(Json.createObjectBuilder().add("body", text).build());
        }

        public Date createdAt() throws IOException {
            try {
                return new GitHub.Time(this.jsn.text("created_at")).date();
            }
            catch (ParseException ex) {
                throw new IOException(ex);
            }
        }

        public Date publishedAt() throws IOException {
            try {
                return new GitHub.Time(this.jsn.text("published_at")).date();
            }
            catch (ParseException ex) {
                throw new IOException(ex);
            }
        }

        public boolean draft() throws IOException {
            return this.json().getBoolean("draft", Boolean.FALSE.booleanValue());
        }

        public void draft(boolean draft) throws IOException {
            this.release.patch(Json.createObjectBuilder().add("draft", draft).build());
        }

        public boolean prerelease() throws IOException {
            return Boolean.parseBoolean(((JsonValue)this.json().getOrDefault((Object)"prerelease", (Object)JsonValue.FALSE)).toString().replace("\"", ""));
        }

        public void prerelease(boolean pre) throws IOException {
            this.release.patch(Json.createObjectBuilder().add("prerelease", pre).build());
        }

        @Override
        public void delete() throws IOException {
            this.release.delete();
        }

        @Generated
        public String toString() {
            return "Release.Smart(release=" + this.release + ", jsn=" + this.jsn + ")";
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Smart)) {
                return false;
            }
            Smart other = (Smart)o;
            Release this$release = this.release;
            Release other$release = other.release;
            if (this$release == null ? other$release != null : !this$release.equals(other$release)) {
                return false;
            }
            SmartJson this$jsn = this.jsn;
            SmartJson other$jsn = other.jsn;
            return !(this$jsn == null ? other$jsn != null : !((Object)this$jsn).equals(other$jsn));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Release $release = this.release;
            result = result * 59 + ($release == null ? 43 : $release.hashCode());
            SmartJson $jsn = this.jsn;
            result = result * 59 + ($jsn == null ? 43 : ((Object)$jsn).hashCode());
            return result;
        }
    }
}

