/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.GitHub;
import com.jcabi.github.JsonPatchable;
import com.jcabi.github.JsonReadable;
import com.jcabi.github.Repo;
import com.jcabi.github.SmartJson;
import com.jcabi.github.User;
import jakarta.json.Json;
import jakarta.json.JsonObject;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.ParseException;
import java.util.Date;
import lombok.Generated;

@Immutable
public interface Milestone
extends Comparable<Milestone>,
JsonReadable,
JsonPatchable {
    public static final String OPEN_STATE = "open";
    public static final String CLOSED_STATE = "closed";

    public Repo repo();

    public int number();

    @Immutable
    @Loggable(value=1)
    public static final class Smart
    implements Milestone {
        private static final String STATE = "state";
        private static final String DESCRIPTION = "description";
        private static final String TITLE = "title";
        private static final String DUE_ON = "due_on";
        private final transient Milestone milestone;
        private final transient SmartJson jsn;

        public Smart(Milestone mls) {
            this.milestone = mls;
            this.jsn = new SmartJson(mls);
        }

        public User creator() throws IOException {
            return this.milestone.repo().github().users().get(this.jsn.value("creator", JsonObject.class).getString("login"));
        }

        public boolean isOpen() throws IOException {
            return Milestone.OPEN_STATE.equals(this.state());
        }

        public void open() throws IOException {
            this.state(Milestone.OPEN_STATE);
        }

        public void close() throws IOException {
            this.state(Milestone.CLOSED_STATE);
        }

        public String state() throws IOException {
            return this.jsn.text(STATE);
        }

        public void state(String state) throws IOException {
            this.milestone.patch(Json.createObjectBuilder().add(STATE, state).build());
        }

        public String title() throws IOException {
            return this.jsn.text(TITLE);
        }

        public void title(String title) throws IOException {
            this.milestone.patch(Json.createObjectBuilder().add(TITLE, title).build());
        }

        public String description() throws IOException {
            return this.jsn.text(DESCRIPTION);
        }

        public void description(String description) throws IOException {
            this.milestone.patch(Json.createObjectBuilder().add(DESCRIPTION, description).build());
        }

        public URL url() throws IOException {
            try {
                return new URI(this.jsn.text("url")).toURL();
            }
            catch (URISyntaxException ex) {
                throw new IllegalArgumentException(ex);
            }
        }

        public Date createdAt() throws IOException {
            try {
                return new GitHub.Time(this.jsn.text("created_at")).date();
            }
            catch (ParseException ex) {
                throw new IllegalStateException(ex);
            }
        }

        public Date dueOn() throws IOException {
            try {
                return new GitHub.Time(this.jsn.text(DUE_ON)).date();
            }
            catch (ParseException ex) {
                throw new IllegalStateException(ex);
            }
        }

        public void dueOn(Date dueon) throws IOException {
            this.milestone.patch(Json.createObjectBuilder().add(DUE_ON, new GitHub.Time(dueon).toString()).build());
        }

        public int openIssues() throws IOException {
            return this.jsn.number("open_issues");
        }

        public int closedIssues() throws IOException {
            return this.jsn.number("closed_issues");
        }

        @Override
        public Repo repo() {
            return this.milestone.repo();
        }

        @Override
        public int number() {
            return this.milestone.number();
        }

        @Override
        public JsonObject json() throws IOException {
            return this.milestone.json();
        }

        @Override
        public void patch(JsonObject json) throws IOException {
            this.milestone.patch(json);
        }

        @Override
        public int compareTo(Milestone obj) {
            return this.milestone.compareTo(obj);
        }

        @Generated
        public String toString() {
            return "Milestone.Smart(milestone=" + this.milestone + ", jsn=" + this.jsn + ")";
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Smart)) {
                return false;
            }
            Smart other = (Smart)o;
            Milestone this$milestone = this.milestone;
            Milestone other$milestone = other.milestone;
            if (this$milestone == null ? other$milestone != null : !this$milestone.equals(other$milestone)) {
                return false;
            }
            SmartJson this$jsn = this.jsn;
            SmartJson other$jsn = other.jsn;
            return !(this$jsn == null ? other$jsn != null : !((Object)this$jsn).equals(other$jsn));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Milestone $milestone = this.milestone;
            result = result * 59 + ($milestone == null ? 43 : $milestone.hashCode());
            SmartJson $jsn = this.jsn;
            result = result * 59 + ($jsn == null ? 43 : ((Object)$jsn).hashCode());
            return result;
        }
    }
}

