/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.Coordinates;
import com.jcabi.github.Release;
import com.jcabi.github.ReleaseAsset;
import com.jcabi.github.ReleaseAssets;
import com.jcabi.github.RtPagination;
import com.jcabi.github.RtReleaseAsset;
import com.jcabi.github.RtValuePagination;
import com.jcabi.http.Request;
import com.jcabi.http.response.JsonResponse;
import com.jcabi.http.response.RestResponse;
import java.io.IOException;
import java.net.URI;
import javax.json.JsonObject;

@Immutable
@Loggable(value=1)
final class RtReleaseAssets
implements ReleaseAssets {
    private final transient Request entry;
    private final transient Request request;
    private final transient Release owner;

    RtReleaseAssets(Request req, Release release) {
        this.entry = req;
        Coordinates coords = release.repo().coordinates();
        this.request = this.entry.uri().path("/repos").path(coords.user()).path(coords.repo()).path("/releases").path(Integer.toString(release.number())).path("/assets").back();
        this.owner = release;
    }

    @Override
    public Release release() {
        return this.owner;
    }

    @Override
    public Iterable<ReleaseAsset> iterate() {
        return new RtPagination<ReleaseAsset>(this.request.uri().back().method("GET"), new RtValuePagination.Mapping<ReleaseAsset, JsonObject>(){

            @Override
            public ReleaseAsset map(JsonObject value) {
                return RtReleaseAssets.this.get(value.getInt("id"));
            }
        });
    }

    @Override
    public ReleaseAsset upload(byte[] content, String type, String name) throws IOException {
        return this.get(((JsonResponse)((RestResponse)this.request.uri().set(URI.create("https://uploads.github.com")).path("/repos").path(this.owner.repo().coordinates().user()).path(this.owner.repo().coordinates().repo()).path("/releases").path(String.valueOf(this.owner.number())).path("/assets").queryParam("name", (Object)name).back().method("POST").reset("Content-Type").header("Content-Type", (Object)type).body().set(content).back().fetch().as(RestResponse.class)).assertStatus(201).as(JsonResponse.class)).json().readObject().getInt("id"));
    }

    @Override
    public ReleaseAsset get(int number) {
        return new RtReleaseAsset(this.entry, this.owner, number);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RtReleaseAssets)) {
            return false;
        }
        RtReleaseAssets other = (RtReleaseAssets)o;
        Request this$request = this.request;
        Request other$request = other.request;
        if (this$request == null ? other$request != null : !this$request.equals(other$request)) {
            return false;
        }
        Release this$owner = this.owner;
        Release other$owner = other.owner;
        return !(this$owner == null ? other$owner != null : !this$owner.equals(other$owner));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Request $request = this.request;
        result = result * 59 + ($request == null ? 43 : $request.hashCode());
        Release $owner = this.owner;
        result = result * 59 + ($owner == null ? 43 : $owner.hashCode());
        return result;
    }
}

