/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github;

import com.jcabi.aspects.Immutable;
import com.jcabi.github.RtPagination;
import com.jcabi.github.RtValuePagination;
import com.jcabi.http.Request;
import com.jcabi.http.RequestBody;
import com.jcabi.http.RequestURI;
import com.jcabi.http.Response;
import com.jcabi.http.Wire;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonObject;

@Immutable
final class RtSearchPagination<T>
implements Iterable<T> {
    private final transient Request request;
    private final transient RtValuePagination.Mapping<T, JsonObject> mapping;

    RtSearchPagination(Request req, String path, String keywords, String sort, String order, RtValuePagination.Mapping<T, JsonObject> mppng) {
        this.request = req.uri().path(path).queryParam("q", (Object)keywords).queryParam("sort", (Object)sort).queryParam("order", (Object)order).back();
        this.mapping = mppng;
    }

    @Override
    public Iterator<T> iterator() {
        return new RtPagination<T>(new SearchRequest(this.request), this.mapping).iterator();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        return o instanceof RtSearchPagination;
    }

    public int hashCode() {
        int result = 1;
        return result;
    }

    @Immutable
    private static final class SearchURI
    implements RequestURI {
        private final transient RequestURI address;

        public SearchURI(RequestURI uri) {
            this.address = uri;
        }

        public Request back() {
            return new SearchRequest(this.address.back());
        }

        public URI get() {
            return this.address.get();
        }

        public RequestURI set(URI uri) {
            return new SearchURI(this.address.set(uri));
        }

        public RequestURI queryParam(String name, Object value) {
            return new SearchURI(this.address.queryParam(name, value));
        }

        public RequestURI queryParams(Map<String, String> map) {
            return new SearchURI(this.address.queryParams(map));
        }

        public RequestURI path(String segment) {
            return new SearchURI(this.address.path(segment));
        }

        public RequestURI userInfo(String info) {
            return new SearchURI(this.address.userInfo(info));
        }

        public RequestURI port(int num) {
            return new SearchURI(this.address.port(num));
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SearchURI)) {
                return false;
            }
            SearchURI other = (SearchURI)o;
            RequestURI this$address = this.address;
            RequestURI other$address = other.address;
            return !(this$address == null ? other$address != null : !this$address.equals(other$address));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            RequestURI $address = this.address;
            result = result * 59 + ($address == null ? 43 : $address.hashCode());
            return result;
        }
    }

    @Immutable
    private static final class Hidden
    implements Response {
        private final transient Response response;

        Hidden(Response resp) {
            this.response = resp;
        }

        public Request back() {
            return new SearchRequest(this.response.back());
        }

        public int status() {
            return this.response.status();
        }

        public String reason() {
            return this.response.reason();
        }

        public Map<String, List<String>> headers() {
            return this.response.headers();
        }

        public String body() {
            return Json.createReader((Reader)new StringReader(this.response.body())).readObject().getJsonArray("items").toString();
        }

        public byte[] binary() {
            try {
                return this.body().getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException ex) {
                throw new IllegalStateException(ex);
            }
        }

        public <T extends Response> T as(Class<T> type) {
            try {
                return (T)((Response)type.getDeclaredConstructor(Response.class).newInstance(this));
            }
            catch (InstantiationException ex) {
                throw new IllegalStateException(ex);
            }
            catch (IllegalAccessException ex) {
                throw new IllegalStateException(ex);
            }
            catch (InvocationTargetException ex) {
                throw new IllegalStateException(ex);
            }
            catch (NoSuchMethodException ex) {
                throw new IllegalStateException(ex);
            }
        }
    }

    private static final class SearchRequest
    implements Request {
        private final transient Request request;

        SearchRequest(Request req) {
            this.request = req;
        }

        public RequestURI uri() {
            return new SearchURI(this.request.uri());
        }

        public RequestBody body() {
            return this.request.body();
        }

        public Request header(String name, Object value) {
            return new SearchRequest(this.request.header(name, value));
        }

        public Request reset(String name) {
            return new SearchRequest(this.request.reset(name));
        }

        public Request method(String method) {
            return new SearchRequest(this.request.method(method));
        }

        public Request timeout(int first, int second) {
            return new SearchRequest(this.request);
        }

        public Response fetch() throws IOException {
            return new Hidden(this.request.fetch());
        }

        public Response fetch(InputStream stream) throws IOException {
            return new Hidden(this.request.fetch(stream));
        }

        public <T extends Wire> Request through(Class<T> type, Object ... args) {
            return new SearchRequest(this.request.through(type, args));
        }
    }
}

