/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.Coordinates;
import com.jcabi.github.Issue;
import com.jcabi.github.Issues;
import com.jcabi.github.Repo;
import com.jcabi.github.RtIssue;
import com.jcabi.github.RtPagination;
import com.jcabi.github.RtValuePagination;
import com.jcabi.github.Search;
import com.jcabi.http.Request;
import com.jcabi.http.response.JsonResponse;
import com.jcabi.http.response.RestResponse;
import java.io.IOException;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonStructure;

@Immutable
@Loggable(value=1)
final class RtIssues
implements Issues {
    private final transient Request entry;
    private final transient Request request;
    private final transient Repo owner;

    RtIssues(Request req, Repo repo) {
        this.entry = req;
        Coordinates coords = repo.coordinates();
        this.request = this.entry.uri().path("/repos").path(coords.user()).path(coords.repo()).path("/issues").back();
        this.owner = repo;
    }

    public String toString() {
        return this.request.uri().get().toString();
    }

    @Override
    public Repo repo() {
        return this.owner;
    }

    @Override
    public Issue get(int number) {
        return new RtIssue(this.entry, this.owner, number);
    }

    @Override
    public Issue create(String title, String body) throws IOException {
        JsonObject json = Json.createObjectBuilder().add("title", title).add("body", body).build();
        return this.get(((JsonResponse)((RestResponse)this.request.method("POST").body().set((JsonStructure)json).back().fetch().as(RestResponse.class)).assertStatus(201).as(JsonResponse.class)).json().readObject().getInt("number"));
    }

    @Override
    public Iterable<Issue> iterate(Map<String, String> params) {
        return new RtPagination<Issue>(this.request.uri().queryParams(params).back(), new RtValuePagination.Mapping<Issue, JsonObject>(){

            @Override
            public Issue map(JsonObject object) {
                return RtIssues.this.get(object.getInt("number"));
            }
        });
    }

    @Override
    public Iterable<Issue> search(Issues.Sort sort, Search.Order direction, EnumMap<Issues.Qualifier, String> qualifiers) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        for (Map.Entry<Issues.Qualifier, String> pair : qualifiers.entrySet()) {
            params.put(pair.getKey().identifier(), pair.getValue());
        }
        params.put("sort", sort.identifier());
        params.put("direction", direction.identifier());
        return this.iterate(params);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RtIssues)) {
            return false;
        }
        RtIssues other = (RtIssues)o;
        Request this$entry = this.entry;
        Request other$entry = other.entry;
        if (this$entry == null ? other$entry != null : !this$entry.equals(other$entry)) {
            return false;
        }
        Request this$request = this.request;
        Request other$request = other.request;
        if (this$request == null ? other$request != null : !this$request.equals(other$request)) {
            return false;
        }
        Repo this$owner = this.owner;
        Repo other$owner = other.owner;
        return !(this$owner == null ? other$owner != null : !this$owner.equals(other$owner));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Request $entry = this.entry;
        result = result * 59 + ($entry == null ? 43 : $entry.hashCode());
        Request $request = this.request;
        result = result * 59 + ($request == null ? 43 : $request.hashCode());
        Repo $owner = this.owner;
        result = result * 59 + ($owner == null ? 43 : $owner.hashCode());
        return result;
    }
}

