/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.Coordinates;
import com.jcabi.github.Event;
import com.jcabi.github.IssueEvents;
import com.jcabi.github.Repo;
import com.jcabi.github.RtEvent;
import com.jcabi.github.RtPagination;
import com.jcabi.github.RtValuePagination;
import com.jcabi.http.Request;
import javax.json.JsonObject;

@Immutable
@Loggable(value=1)
final class RtIssueEvents
implements IssueEvents {
    private final transient Request entry;
    private final transient Request request;
    private final transient Repo owner;

    RtIssueEvents(Request req, Repo repo) {
        this.entry = req;
        Coordinates coords = repo.coordinates();
        this.request = this.entry.uri().path("/repos").path(coords.user()).path(coords.repo()).path("/issues").path("/events").back();
        this.owner = repo;
    }

    public String toString() {
        return this.request.uri().get().toString();
    }

    @Override
    public Repo repo() {
        return this.owner;
    }

    @Override
    public Event get(int number) {
        return new RtEvent(this.entry, this.owner, number);
    }

    @Override
    public Iterable<Event> iterate() {
        return new RtPagination<Event>(this.request, new RtValuePagination.Mapping<Event, JsonObject>(){

            @Override
            public Event map(JsonObject object) {
                return new RtEvent(RtIssueEvents.this.entry, RtIssueEvents.this.owner, object.getInt("id"));
            }
        });
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RtIssueEvents)) {
            return false;
        }
        RtIssueEvents other = (RtIssueEvents)o;
        Request this$entry = this.entry;
        Request other$entry = other.entry;
        if (this$entry == null ? other$entry != null : !this$entry.equals(other$entry)) {
            return false;
        }
        Request this$request = this.request;
        Request other$request = other.request;
        if (this$request == null ? other$request != null : !this$request.equals(other$request)) {
            return false;
        }
        Repo this$owner = this.owner;
        Repo other$owner = other.owner;
        return !(this$owner == null ? other$owner != null : !this$owner.equals(other$owner));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Request $entry = this.entry;
        result = result * 59 + ($entry == null ? 43 : $entry.hashCode());
        Request $request = this.request;
        result = result * 59 + ($request == null ? 43 : $request.hashCode());
        Repo $owner = this.owner;
        result = result * 59 + ($owner == null ? 43 : $owner.hashCode());
        return result;
    }
}

