/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.Assignees;
import com.jcabi.github.Coordinates;
import com.jcabi.github.Repo;
import com.jcabi.github.RtPagination;
import com.jcabi.github.RtUser;
import com.jcabi.github.RtValuePagination;
import com.jcabi.github.User;
import com.jcabi.http.Request;
import com.jcabi.http.response.RestResponse;
import java.io.IOException;
import javax.json.JsonObject;
import org.hamcrest.Matchers;

@Immutable
@Loggable(value=1)
final class RtAssignees
implements Assignees {
    private final transient Request entry;
    private final transient Request request;
    private final transient Repo owner;

    RtAssignees(Request req, Repo repo) {
        this.entry = req;
        Coordinates coords = repo.coordinates();
        this.request = this.entry.uri().path("/repos").path(coords.user()).path(coords.repo()).path("/assignees").back();
        this.owner = repo;
    }

    @Override
    public Iterable<User> iterate() {
        return new RtPagination<User>(this.request, new RtValuePagination.Mapping<User, JsonObject>(){

            @Override
            public User map(JsonObject object) {
                return new RtUser(RtAssignees.this.owner.github(), RtAssignees.this.entry, object.getString("login"));
            }
        });
    }

    @Override
    public boolean check(String login) throws IOException {
        return ((RestResponse)this.request.method("GET").uri().path(login).back().fetch().as(RestResponse.class)).assertStatus(Matchers.isOneOf((Object[])new Integer[]{204, 404})).status() == 204;
    }

    public String toString() {
        return this.request.uri().get().toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RtAssignees)) {
            return false;
        }
        RtAssignees other = (RtAssignees)o;
        Request this$entry = this.entry;
        Request other$entry = other.entry;
        if (this$entry == null ? other$entry != null : !this$entry.equals(other$entry)) {
            return false;
        }
        Request this$request = this.request;
        Request other$request = other.request;
        if (this$request == null ? other$request != null : !this$request.equals(other$request)) {
            return false;
        }
        Repo this$owner = this.owner;
        Repo other$owner = other.owner;
        return !(this$owner == null ? other$owner != null : !this$owner.equals(other$owner));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Request $entry = this.entry;
        result = result * 59 + ($entry == null ? 43 : $entry.hashCode());
        Request $request = this.request;
        result = result * 59 + ($request == null ? 43 : $request.hashCode());
        Repo $owner = this.owner;
        result = result * 59 + ($owner == null ? 43 : $owner.hashCode());
        return result;
    }
}

