/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.JsonPatchable;
import com.jcabi.github.JsonReadable;
import com.jcabi.github.Repo;
import com.jcabi.github.SmartJson;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.json.JsonObject;
import javax.xml.bind.DatatypeConverter;

@Immutable
public interface Content
extends Comparable<Content>,
JsonReadable,
JsonPatchable {
    public Repo repo();

    public String path();

    public InputStream raw() throws IOException;

    @Immutable
    @Loggable(value=1)
    public static final class Smart
    implements Content {
        private final transient Content content;
        private final transient SmartJson jsn;

        public Smart(Content cont) {
            this.content = cont;
            this.jsn = new SmartJson(cont);
        }

        public String name() throws IOException {
            return this.jsn.text("name");
        }

        public String type() throws IOException {
            return this.jsn.text("type");
        }

        public int size() throws IOException {
            return this.jsn.number("size");
        }

        public String sha() throws IOException {
            return this.jsn.text("sha");
        }

        public URL url() throws IOException {
            return new URL(this.jsn.text("url"));
        }

        public URL htmlUrl() throws IOException {
            return new URL(this.jsn.text("html_url"));
        }

        public URL gitUrl() throws IOException {
            return new URL(this.jsn.text("git_url"));
        }

        public String content() throws IOException {
            return this.jsn.text("content");
        }

        public byte[] decoded() throws IOException {
            return DatatypeConverter.parseBase64Binary((String)this.content());
        }

        @Override
        public int compareTo(Content cont) {
            return this.content.compareTo(cont);
        }

        @Override
        public void patch(JsonObject json) throws IOException {
            this.content.patch(json);
        }

        @Override
        public JsonObject json() throws IOException {
            return this.content.json();
        }

        @Override
        public Repo repo() {
            return this.content.repo();
        }

        @Override
        public String path() {
            return this.content.path();
        }

        @Override
        public InputStream raw() throws IOException {
            return this.content.raw();
        }

        public String toString() {
            return "Content.Smart(content=" + this.content + ", jsn=" + this.jsn + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Smart)) {
                return false;
            }
            Smart other = (Smart)o;
            Content this$content = this.content;
            Content other$content = other.content;
            if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
                return false;
            }
            SmartJson this$jsn = this.jsn;
            SmartJson other$jsn = other.jsn;
            return !(this$jsn == null ? other$jsn != null : !((Object)this$jsn).equals(other$jsn));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Content $content = this.content;
            result = result * 59 + ($content == null ? 43 : $content.hashCode());
            SmartJson $jsn = this.jsn;
            result = result * 59 + ($jsn == null ? 43 : ((Object)$jsn).hashCode());
            return result;
        }
    }
}

