/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github;

import com.jcabi.log.Logger;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;

public final class Smarts<T>
implements Iterable<T> {
    private final transient Iterable<?> origin;

    public Smarts(Iterable<?> items) {
        this.origin = items;
    }

    public String toString() {
        return this.origin.toString();
    }

    @Override
    public Iterator<T> iterator() {
        final Iterator<?> iterator = this.origin.iterator();
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public T next() {
                return Smarts.wrap(iterator.next());
            }

            @Override
            public void remove() {
                iterator.remove();
            }
        };
    }

    private static <X> X wrap(Object object) {
        try {
            return (X)Smarts.type(object).newInstance(object);
        }
        catch (InvocationTargetException ex) {
            throw new IllegalStateException(ex);
        }
        catch (InstantiationException ex) {
            throw new IllegalStateException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalStateException(ex);
        }
    }

    private static Constructor<?> type(Object object) {
        for (Class<?> iface : object.getClass().getInterfaces()) {
            try {
                return Class.forName(String.format("%s$Smart", iface.getName())).getDeclaredConstructor(iface);
            }
            catch (ClassNotFoundException ex) {
                Logger.debug(Smarts.class, (String)"%s: %s", (Object[])new Object[]{iface.getName(), ex});
            }
            catch (NoSuchMethodException ex) {
                throw new IllegalStateException(ex);
            }
        }
        throw new IllegalStateException(String.format("can't find Smart decorator for %s", object.getClass().getName()));
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Smarts)) {
            return false;
        }
        Smarts other = (Smarts)o;
        Iterable<?> this$origin = this.origin;
        Iterable<?> other$origin = other.origin;
        return !(this$origin == null ? other$origin != null : !this$origin.equals(other$origin));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Iterable<?> $origin = this.origin;
        result = result * 59 + ($origin == null ? 43 : $origin.hashCode());
        return result;
    }
}

