/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.dynamo.mock;

import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.AttributeValueUpdate;
import com.amazonaws.services.dynamodbv2.model.ComparisonOperator;
import com.amazonaws.services.dynamodbv2.model.Condition;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.aspects.aj.ImmutabilityChecker;
import com.jcabi.aspects.aj.MethodLogger;
import com.jcabi.dynamo.AttributeUpdates;
import com.jcabi.dynamo.Attributes;
import com.jcabi.dynamo.Conditions;
import com.jcabi.dynamo.mock.H2Data$AjcClosure1;
import com.jcabi.dynamo.mock.H2Data$AjcClosure3;
import com.jcabi.dynamo.mock.H2Data$AjcClosure5;
import com.jcabi.dynamo.mock.H2Data$AjcClosure7;
import com.jcabi.dynamo.mock.MkData;
import com.jcabi.jdbc.JdbcSession;
import com.jcabi.jdbc.Outcome;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Properties;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.h2.Driver;

@Immutable
@Loggable(value=1)
public final class H2Data
implements MkData {
    private static final Outcome<Iterable<Attributes>> OUTCOME;
    private static final Function<String, String> WHERE;
    private static final Function<String, String> CREATE_KEY;
    private static final Function<String, String> CREATE_ATTR;
    private final transient String jdbc;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;

    public H2Data() throws IOException {
        File file = File.createTempFile("jcabi-dynamo-", ".h2");
        H2Data ajc$aspectInstance = this;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this);
        try {
            JoinPoint joinPoint2 = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)ajc$aspectInstance, (Object)ajc$aspectInstance);
            try {
            }
            finally {
                ImmutabilityChecker.aspectOf().after(joinPoint2);
            }
            ajc$aspectInstance.jdbc = String.format("jdbc:h2:file:%s", file.getAbsolutePath());
        }
        finally {
            ImmutabilityChecker.aspectOf().after(joinPoint);
        }
    }

    public H2Data(File file) {
        File file2 = file;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)file2);
        try {
            JoinPoint joinPoint2 = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
            try {
            }
            finally {
                ImmutabilityChecker.aspectOf().after(joinPoint2);
            }
            this.jdbc = String.format("jdbc:h2:file:%s", file.getAbsolutePath());
        }
        finally {
            ImmutabilityChecker.aspectOf().after(joinPoint);
        }
    }

    @Override
    public Iterable<Attributes> iterate(String table, Conditions conds) throws IOException {
        String string = table;
        Conditions conditions = conds;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)string, (Object)conditions);
        if (!MethodLogger.ajc$cflowCounter$0.isValid()) {
            Object[] objectArray = new Object[]{this, string, conditions, joinPoint};
            return (Iterable)MethodLogger.aspectOf().wrapClass(new H2Data$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
        }
        return H2Data.iterate_aroundBody0(this, string, conditions, joinPoint);
    }

    @Override
    public void put(String table, Attributes attrs) throws IOException {
        String string = table;
        Attributes attributes = attrs;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)string, (Object)attributes);
        if (!MethodLogger.ajc$cflowCounter$0.isValid()) {
            Object[] objectArray = new Object[]{this, string, attributes, joinPoint};
            MethodLogger.aspectOf().wrapClass(new H2Data$AjcClosure3(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        H2Data.put_aroundBody2(this, string, attributes, joinPoint);
    }

    @Override
    public void update(String table, Attributes keys, AttributeUpdates attrs) throws IOException {
        String string = table;
        Attributes attributes = keys;
        AttributeUpdates attributeUpdates = attrs;
        Object[] objectArray = new Object[]{string, attributes, attributeUpdates};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object[])objectArray);
        if (!MethodLogger.ajc$cflowCounter$0.isValid()) {
            Object[] objectArray2 = new Object[]{this, string, attributes, attributeUpdates, joinPoint};
            MethodLogger.aspectOf().wrapClass(new H2Data$AjcClosure5(objectArray2).linkClosureAndJoinPoint(69648));
            return;
        }
        H2Data.update_aroundBody4(this, string, attributes, attributeUpdates, joinPoint);
    }

    public MkData with(String table, String[] keys, String[] attrs) throws IOException {
        String string = table;
        String[] stringArray = keys;
        String[] stringArray2 = attrs;
        Object[] objectArray = new Object[]{string, stringArray, stringArray2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object[])objectArray);
        if (!MethodLogger.ajc$cflowCounter$0.isValid()) {
            Object[] objectArray2 = new Object[]{this, string, stringArray, stringArray2, joinPoint};
            return (MkData)MethodLogger.aspectOf().wrapClass(new H2Data$AjcClosure7(objectArray2).linkClosureAndJoinPoint(69648));
        }
        return H2Data.with_aroundBody6(this, string, stringArray, stringArray2, joinPoint);
    }

    private Connection connection() throws SQLException {
        return new Driver().connect(this.jdbc, new Properties());
    }

    private static String value(AttributeValue attr) {
        String val = attr.getS();
        if (val == null) {
            val = attr.getN();
        }
        if (val == null) {
            throw new IllegalArgumentException("we support only N and S at the moment");
        }
        return val;
    }

    public String toString() {
        return "H2Data(jdbc=" + this.jdbc + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof H2Data)) {
            return false;
        }
        H2Data other = (H2Data)o;
        String this$jdbc = this.jdbc;
        String other$jdbc = other.jdbc;
        return !(this$jdbc == null ? other$jdbc != null : !this$jdbc.equals(other$jdbc));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $jdbc = this.jdbc;
        result = result * 59 + ($jdbc == null ? 0 : $jdbc.hashCode());
        return result;
    }

    static {
        H2Data.ajc$preClinit();
        OUTCOME = new Outcome<Iterable<Attributes>>(){

            public Iterable<Attributes> handle(ResultSet rset, Statement stmt) throws SQLException {
                LinkedList<Attributes> items = new LinkedList<Attributes>();
                while (rset.next()) {
                    items.add(this.fetch(rset));
                }
                return items;
            }

            private Attributes fetch(ResultSet rset) throws SQLException {
                ResultSetMetaData meta = rset.getMetaData();
                Attributes attrs = new Attributes();
                for (int idx = 0; idx < meta.getColumnCount(); ++idx) {
                    attrs = attrs.with(meta.getColumnName(idx + 1), rset.getString(idx + 1));
                }
                return attrs;
            }
        };
        WHERE = new Function<String, String>(){

            public String apply(String key) {
                return String.format("%s = ?", key);
            }
        };
        CREATE_KEY = new Function<String, String>(){

            public String apply(String key) {
                return String.format("%s VARCHAR PRIMARY KEY", key);
            }
        };
        CREATE_ATTR = new Function<String, String>(){

            public String apply(String key) {
                return String.format("%s CLOB", key);
            }
        };
    }

    static /* synthetic */ Iterable iterate_aroundBody0(H2Data ajc$this, String table, Conditions conds, JoinPoint joinPoint) {
        try {
            StringBuilder sql = new StringBuilder("SELECT * FROM ").append(table);
            if (!conds.isEmpty()) {
                sql.append(" WHERE ");
                Joiner.on((String)" AND ").appendTo(sql, Iterables.transform(conds.keySet(), WHERE));
            }
            JdbcSession session = new JdbcSession(ajc$this.connection()).sql(sql.toString());
            for (Condition cond : conds.values()) {
                if (cond.getAttributeValueList().size() != 1) {
                    throw new UnsupportedOperationException("at the moment only one value of condition is supported");
                }
                if (!cond.getComparisonOperator().equals(ComparisonOperator.EQ.toString())) {
                    throw new UnsupportedOperationException(String.format("at the moment only EQ operator is supported: %s", cond.getComparisonOperator()));
                }
                AttributeValue val = (AttributeValue)cond.getAttributeValueList().get(0);
                session = session.set((Object)H2Data.value(val));
            }
            return (Iterable)session.select(OUTCOME);
        }
        catch (SQLException ex) {
            throw new IOException(ex);
        }
    }

    static /* synthetic */ void put_aroundBody2(H2Data ajc$this, String table, Attributes attrs, JoinPoint joinPoint) {
        try {
            JdbcSession session = new JdbcSession(ajc$this.connection());
            for (AttributeValue value : attrs.values()) {
                session = session.set((Object)H2Data.value(value));
            }
            session.sql(String.format("INSERT INTO %s (%s) VALUES (%s)", table, Joiner.on((char)',').join(attrs.keySet()), Joiner.on((char)',').join(Collections.nCopies(attrs.size(), "?"))));
            session.execute();
        }
        catch (SQLException ex) {
            throw new IOException(ex);
        }
    }

    static /* synthetic */ void update_aroundBody4(H2Data ajc$this, String table, Attributes keys, AttributeUpdates attrs, JoinPoint joinPoint) {
        try {
            JdbcSession session = new JdbcSession(ajc$this.connection());
            for (AttributeValueUpdate attributeValueUpdate : attrs.values()) {
                session = session.set((Object)H2Data.value(attributeValueUpdate.getValue()));
            }
            for (AttributeValue attributeValue : keys.values()) {
                session = session.set((Object)H2Data.value(attributeValue));
            }
            session.sql(String.format("UPDATE %s SET %s WHERE %s", table, Joiner.on((char)',').join(Iterables.transform(attrs.keySet(), WHERE)), Joiner.on((String)" AND  ").join(Iterables.transform(keys.keySet(), WHERE))));
            session.execute();
        }
        catch (SQLException ex) {
            throw new IOException(ex);
        }
    }

    static /* synthetic */ MkData with_aroundBody6(H2Data ajc$this, String table, String[] keys, String[] attrs, JoinPoint joinPoint) {
        if (keys.length == 0) {
            throw new IllegalArgumentException(String.format("empty list of keys for %s table", table));
        }
        StringBuilder sql = new StringBuilder("CREATE TABLE ").append(table).append(" (");
        Joiner.on((char)',').appendTo(sql, Iterables.transform(Arrays.asList(keys), CREATE_KEY));
        if (attrs.length > 0) {
            sql.append(',');
            Joiner.on((char)',').appendTo(sql, Iterables.transform(Arrays.asList(attrs), CREATE_ATTR));
        }
        sql.append(')');
        try {
            new JdbcSession(ajc$this.connection()).sql(sql.toString()).execute();
        }
        catch (SQLException ex) {
            throw new IOException(ex);
        }
        return ajc$this;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("H2Data.java", H2Data.class);
        ajc$tjp_0 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("1", "com.jcabi.dynamo.mock.MkData", "", "", ""), 162);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "iterate", "com.jcabi.dynamo.mock.H2Data", "java.lang.String:com.jcabi.dynamo.Conditions", "table:conds", "java.io.IOException", "java.lang.Iterable"), 173);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "put", "com.jcabi.dynamo.mock.H2Data", "java.lang.String:com.jcabi.dynamo.Attributes", "table:attrs", "java.io.IOException", "void"), 211);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "update", "com.jcabi.dynamo.mock.H2Data", "java.lang.String:com.jcabi.dynamo.Attributes:com.jcabi.dynamo.AttributeUpdates", "table:keys:attrs", "java.io.IOException", "void"), 234);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "with", "com.jcabi.dynamo.mock.H2Data", "java.lang.String:[Ljava.lang.String;:[Ljava.lang.String;", "table:keys:attrs", "java.io.IOException", "com.jcabi.dynamo.mock.MkData"), 269);
        ajc$tjp_5 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("1", "com.jcabi.dynamo.mock.H2Data", "", "", "java.io.IOException"), 155);
        ajc$tjp_6 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("1", "com.jcabi.dynamo.mock.H2Data", "java.io.File", "file", ""), 162);
    }
}

