/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.restassured.module.mockmvc.config;

import com.jayway.restassured.config.Config;
import com.jayway.restassured.internal.assertion.AssertParameter;

public class MockMvcParamConfig
implements Config {
    private final boolean userConfigured;
    private final UpdateStrategy queryParamsUpdateStrategy;
    private final UpdateStrategy formParamsUpdateStrategy;
    private final UpdateStrategy requestParameterUpdateStrategy;
    private final UpdateStrategy attributeUpdateStrategy;

    public MockMvcParamConfig() {
        this(UpdateStrategy.MERGE, UpdateStrategy.MERGE, UpdateStrategy.MERGE, UpdateStrategy.MERGE, false);
    }

    public MockMvcParamConfig(UpdateStrategy queryParamsUpdateStrategy, UpdateStrategy formParamsUpdateStrategy, UpdateStrategy requestParameterUpdateStrategy, UpdateStrategy attributeUpdateStrategy) {
        this(queryParamsUpdateStrategy, formParamsUpdateStrategy, requestParameterUpdateStrategy, attributeUpdateStrategy, true);
    }

    private MockMvcParamConfig(UpdateStrategy queryParamsUpdateStrategy, UpdateStrategy formParamsUpdateStrategy, UpdateStrategy requestParameterUpdateStrategy, UpdateStrategy attributeUpdateStrategy, boolean userConfigured) {
        AssertParameter.notNull((Object)((Object)queryParamsUpdateStrategy), (String)"Query param update strategy");
        AssertParameter.notNull((Object)((Object)requestParameterUpdateStrategy), (String)"Request param update strategy");
        AssertParameter.notNull((Object)((Object)formParamsUpdateStrategy), (String)"Form param update strategy");
        AssertParameter.notNull((Object)((Object)attributeUpdateStrategy), (String)"Attribute update strategy");
        this.queryParamsUpdateStrategy = queryParamsUpdateStrategy;
        this.formParamsUpdateStrategy = formParamsUpdateStrategy;
        this.requestParameterUpdateStrategy = requestParameterUpdateStrategy;
        this.attributeUpdateStrategy = attributeUpdateStrategy;
        this.userConfigured = userConfigured;
    }

    public MockMvcParamConfig mergeAllParameters() {
        return new MockMvcParamConfig(UpdateStrategy.MERGE, UpdateStrategy.MERGE, UpdateStrategy.MERGE, UpdateStrategy.MERGE, true);
    }

    public MockMvcParamConfig replaceAllParameters() {
        return new MockMvcParamConfig(UpdateStrategy.REPLACE, UpdateStrategy.REPLACE, UpdateStrategy.REPLACE, UpdateStrategy.REPLACE, true);
    }

    public MockMvcParamConfig formParamsUpdateStrategy(UpdateStrategy updateStrategy) {
        return new MockMvcParamConfig(this.queryParamsUpdateStrategy, updateStrategy, this.requestParameterUpdateStrategy, this.attributeUpdateStrategy, true);
    }

    public MockMvcParamConfig requestParamsUpdateStrategy(UpdateStrategy updateStrategy) {
        return new MockMvcParamConfig(this.queryParamsUpdateStrategy, this.formParamsUpdateStrategy, updateStrategy, this.attributeUpdateStrategy, true);
    }

    public MockMvcParamConfig queryParamsUpdateStrategy(UpdateStrategy updateStrategy) {
        return new MockMvcParamConfig(updateStrategy, this.formParamsUpdateStrategy, this.requestParameterUpdateStrategy, this.attributeUpdateStrategy, true);
    }

    public MockMvcParamConfig attributeUpdateStrategy(UpdateStrategy updateStrategy) {
        return new MockMvcParamConfig(this.queryParamsUpdateStrategy, this.formParamsUpdateStrategy, this.requestParameterUpdateStrategy, updateStrategy, true);
    }

    public UpdateStrategy attributeUpdateStrategy() {
        return this.formParamsUpdateStrategy;
    }

    public UpdateStrategy formParamsUpdateStrategy() {
        return this.formParamsUpdateStrategy;
    }

    public UpdateStrategy requestParamsUpdateStrategy() {
        return this.requestParameterUpdateStrategy;
    }

    public UpdateStrategy queryParamsUpdateStrategy() {
        return this.queryParamsUpdateStrategy;
    }

    public boolean isUserConfigured() {
        return this.userConfigured;
    }

    public static MockMvcParamConfig paramConfig() {
        return new MockMvcParamConfig();
    }

    public MockMvcParamConfig and() {
        return this;
    }

    public MockMvcParamConfig with() {
        return this;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum UpdateStrategy {
        MERGE,
        REPLACE;

    }
}

