/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.restassured.module.mockmvc.internal;

import com.jayway.restassured.authentication.AuthenticationScheme;
import com.jayway.restassured.authentication.NoAuthScheme;
import com.jayway.restassured.builder.MultiPartSpecBuilder;
import com.jayway.restassured.config.EncoderConfig;
import com.jayway.restassured.filter.FilterContext;
import com.jayway.restassured.filter.log.RequestLoggingFilter;
import com.jayway.restassured.internal.RequestSpecificationImpl;
import com.jayway.restassured.internal.ResponseParserRegistrar;
import com.jayway.restassured.internal.ResponseSpecificationImpl;
import com.jayway.restassured.internal.assertion.AssertParameter;
import com.jayway.restassured.internal.filter.FilterContextImpl;
import com.jayway.restassured.internal.http.CharsetExtractor;
import com.jayway.restassured.internal.http.Method;
import com.jayway.restassured.internal.log.LogRepository;
import com.jayway.restassured.internal.support.PathSupport;
import com.jayway.restassured.internal.util.SafeExceptionRethrower;
import com.jayway.restassured.module.mockmvc.config.AsyncConfig;
import com.jayway.restassured.module.mockmvc.config.RestAssuredMockMvcConfig;
import com.jayway.restassured.module.mockmvc.intercept.MockHttpServletRequestBuilderInterceptor;
import com.jayway.restassured.module.mockmvc.internal.ConfigConverter;
import com.jayway.restassured.module.mockmvc.internal.MockMvcMultiPart;
import com.jayway.restassured.module.mockmvc.internal.MockMvcRestAssuredResponseImpl;
import com.jayway.restassured.module.mockmvc.internal.ResponseConverter;
import com.jayway.restassured.module.mockmvc.internal.SpringSecurityClassPathChecker;
import com.jayway.restassured.module.mockmvc.response.MockMvcResponse;
import com.jayway.restassured.module.mockmvc.specification.MockMvcRequestAsyncConfigurer;
import com.jayway.restassured.module.mockmvc.specification.MockMvcRequestAsyncSender;
import com.jayway.restassured.module.mockmvc.specification.MockMvcRequestSender;
import com.jayway.restassured.response.Cookies;
import com.jayway.restassured.response.Header;
import com.jayway.restassured.response.Headers;
import com.jayway.restassured.specification.FilterableRequestSpecification;
import com.jayway.restassured.specification.ResponseSpecification;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.Cookie;
import org.apache.commons.lang3.StringUtils;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.MvcResult;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.ResultActions;
import org.springframework.test.web.servlet.ResultHandler;
import org.springframework.test.web.servlet.request.MockHttpServletRequestBuilder;
import org.springframework.test.web.servlet.request.MockMultipartHttpServletRequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.request.RequestPostProcessor;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MockMvcRequestSenderImpl
implements MockMvcRequestSender,
MockMvcRequestAsyncConfigurer,
MockMvcRequestAsyncSender {
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String CHARSET = "charset";
    private static final String LINE_SEPARATOR = "line.separator";
    private final MockMvc mockMvc;
    private final Map<String, Object> params;
    private final Map<String, Object> queryParams;
    private final Map<String, Object> formParams;
    private final Map<String, Object> attributes;
    private final RestAssuredMockMvcConfig config;
    private final Object requestBody;
    private Headers headers;
    private final Cookies cookies;
    private final List<MockMvcMultiPart> multiParts;
    private final RequestLoggingFilter requestLoggingFilter;
    private final List<ResultHandler> resultHandlers;
    private final List<RequestPostProcessor> requestPostProcessors;
    private final MockHttpServletRequestBuilderInterceptor interceptor;
    private final String basePath;
    private final ResponseSpecification responseSpecification;
    private final Object authentication;
    private final LogRepository logRepository;
    private final boolean isAsyncRequest;

    MockMvcRequestSenderImpl(MockMvc mockMvc, Map<String, Object> params, Map<String, Object> queryParams, Map<String, Object> formParams, Map<String, Object> attributes, RestAssuredMockMvcConfig config, Object requestBody, Headers headers, Cookies cookies, List<MockMvcMultiPart> multiParts, RequestLoggingFilter requestLoggingFilter, List<ResultHandler> resultHandlers, List<RequestPostProcessor> requestPostProcessors, MockHttpServletRequestBuilderInterceptor interceptor, String basePath, ResponseSpecification responseSpecification, Object authentication, LogRepository logRepository) {
        this(mockMvc, params, queryParams, formParams, attributes, config, requestBody, headers, cookies, multiParts, requestLoggingFilter, resultHandlers, requestPostProcessors, interceptor, basePath, responseSpecification, authentication, logRepository, false);
    }

    private MockMvcRequestSenderImpl(MockMvc mockMvc, Map<String, Object> params, Map<String, Object> queryParams, Map<String, Object> formParams, Map<String, Object> attributes, RestAssuredMockMvcConfig config, Object requestBody, Headers headers, Cookies cookies, List<MockMvcMultiPart> multiParts, RequestLoggingFilter requestLoggingFilter, List<ResultHandler> resultHandlers, List<RequestPostProcessor> requestPostProcessors, MockHttpServletRequestBuilderInterceptor interceptor, String basePath, ResponseSpecification responseSpecification, Object authentication, LogRepository logRepository, boolean isAsyncRequest) {
        this.mockMvc = mockMvc;
        this.params = params;
        this.queryParams = queryParams;
        this.formParams = formParams;
        this.attributes = attributes;
        this.config = config;
        this.requestBody = requestBody;
        this.headers = headers;
        this.cookies = cookies;
        this.multiParts = multiParts;
        this.requestLoggingFilter = requestLoggingFilter;
        this.resultHandlers = resultHandlers;
        this.requestPostProcessors = requestPostProcessors;
        this.interceptor = interceptor;
        this.basePath = basePath;
        this.responseSpecification = responseSpecification;
        this.authentication = authentication;
        this.logRepository = logRepository;
        this.isAsyncRequest = isAsyncRequest;
    }

    private Object assembleHeaders(MockHttpServletResponse response) {
        Collection headerNames = response.getHeaderNames();
        ArrayList<Header> headers = new ArrayList<Header>();
        for (String headerName : headerNames) {
            List headerValues = response.getHeaders(headerName);
            for (String headerValue : headerValues) {
                headers.add(new Header(headerName, headerValue));
            }
        }
        return new Headers(headers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MockMvcResponse performRequest(MockHttpServletRequestBuilder requestBuilder) {
        MockMvcRestAssuredResponseImpl restAssuredResponse;
        if (this.interceptor != null) {
            this.interceptor.intercept(requestBuilder);
        }
        if (SpringSecurityClassPathChecker.isSpringSecurityInClasspath() && this.authentication instanceof Authentication) {
            SecurityContextHolder.getContext().setAuthentication((Authentication)this.authentication);
        } else if (this.authentication instanceof Principal) {
            requestBuilder.principal((Principal)this.authentication);
        }
        for (RequestPostProcessor requestPostProcessor : this.requestPostProcessors) {
            requestBuilder.with(requestPostProcessor);
        }
        try {
            ResultActions perform = this.mockMvc.perform((RequestBuilder)requestBuilder);
            if (!this.resultHandlers.isEmpty()) {
                for (ResultHandler resultHandler : this.resultHandlers) {
                    perform.andDo(resultHandler);
                }
            }
            MvcResult mvcResult = this.getMvcResult(perform, this.isAsyncRequest);
            MockHttpServletResponse response = mvcResult.getResponse();
            restAssuredResponse = new MockMvcRestAssuredResponseImpl(perform, this.logRepository);
            restAssuredResponse.setConfig(ConfigConverter.convertToRestAssuredConfig(this.config));
            restAssuredResponse.setContent(response.getContentAsString());
            restAssuredResponse.setContentType(response.getContentType());
            restAssuredResponse.setHasExpectations(false);
            restAssuredResponse.setStatusCode(response.getStatus());
            restAssuredResponse.setResponseHeaders(this.assembleHeaders(response));
            restAssuredResponse.setRpr(this.getRpr());
            restAssuredResponse.setStatusLine(this.assembleStatusLine(response, mvcResult.getResolvedException()));
            if (this.responseSpecification != null) {
                this.responseSpecification.validate(ResponseConverter.toStandardResponse(restAssuredResponse));
            }
        }
        catch (Exception e) {
            MockMvcResponse mockMvcResponse = (MockMvcResponse)SafeExceptionRethrower.safeRethrow((Throwable)e);
            return mockMvcResponse;
        }
        finally {
            if (SpringSecurityClassPathChecker.isSpringSecurityInClasspath()) {
                SecurityContextHolder.clearContext();
            }
        }
        return restAssuredResponse;
    }

    private MvcResult getMvcResult(ResultActions perform, boolean isAsyncRequest) throws Exception {
        MvcResult mvcResult;
        if (isAsyncRequest) {
            MvcResult startedAsyncRequestProcessing = perform.andExpect(MockMvcResultMatchers.request().asyncStarted()).andReturn();
            startedAsyncRequestProcessing.getAsyncResult(this.config.getAsyncConfig().timeoutInMs());
            mvcResult = this.mockMvc.perform(MockMvcRequestBuilders.asyncDispatch((MvcResult)startedAsyncRequestProcessing)).andReturn();
        } else {
            mvcResult = perform.andReturn();
        }
        return mvcResult;
    }

    private ResponseParserRegistrar getRpr() {
        if (this.responseSpecification != null && this.responseSpecification instanceof ResponseSpecificationImpl) {
            return ((ResponseSpecificationImpl)this.responseSpecification).getRpr();
        }
        return new ResponseParserRegistrar();
    }

    private String assembleStatusLine(MockHttpServletResponse response, Exception resolvedException) {
        StringBuilder builder = new StringBuilder();
        builder.append(response.getStatus());
        if (StringUtils.isNotBlank((CharSequence)response.getErrorMessage())) {
            builder.append(" ").append(response.getErrorMessage());
        } else if (resolvedException != null) {
            builder.append(" ").append(resolvedException.getMessage());
        }
        return builder.toString();
    }

    private Object[] mapToArray(Map<String, ?> map) {
        if (map == null) {
            return new Object[0];
        }
        return map.values().toArray(new Object[map.values().size()]);
    }

    private MockMvcResponse sendRequest(HttpMethod method, String path, Object[] pathParams) {
        MockHttpServletRequestBuilder request;
        AssertParameter.notNull((Object)path, (String)"Path");
        if (this.requestBody != null && !this.multiParts.isEmpty()) {
            throw new IllegalStateException("You cannot specify a request body and a multi-part body in the same request. Perhaps you want to change the body to a multi part?");
        }
        if (StringUtils.isNotBlank((CharSequence)this.basePath)) {
            path = PathSupport.mergeAndRemoveDoubleSlash((String)this.basePath, (String)path);
        }
        if (this.multiParts.isEmpty()) {
            request = MockMvcRequestBuilders.request((HttpMethod)method, (String)path, (Object[])pathParams);
        } else {
            if (method != HttpMethod.POST) {
                throw new IllegalArgumentException("Currently multi-part file data uploading only works for " + HttpMethod.POST);
            }
            request = MockMvcRequestBuilders.fileUpload((String)path, (Object[])pathParams);
        }
        String requestContentType = this.findContentType();
        if (!this.params.isEmpty()) {
            new ParamApplier(this.params){

                protected void applyParam(String paramName, String[] paramValues) {
                    request.param(paramName, paramValues);
                }
            }.applyParams();
            if (StringUtils.isBlank((CharSequence)requestContentType) && method == HttpMethod.POST && !this.isInMultiPartMode(request)) {
                this.setContentTypeToApplicationFormUrlEncoded(request);
            }
        }
        if (!this.queryParams.isEmpty()) {
            new ParamApplier(this.queryParams){

                protected void applyParam(String paramName, String[] paramValues) {
                    request.param(paramName, paramValues);
                }
            }.applyParams();
        }
        if (!this.formParams.isEmpty()) {
            if (method == HttpMethod.GET) {
                throw new IllegalArgumentException("Cannot use form parameters in a GET request");
            }
            new ParamApplier(this.formParams){

                protected void applyParam(String paramName, String[] paramValues) {
                    request.param(paramName, paramValues);
                }
            }.applyParams();
            boolean isInMultiPartMode = this.isInMultiPartMode(request);
            if (StringUtils.isBlank((CharSequence)requestContentType) && !isInMultiPartMode) {
                this.setContentTypeToApplicationFormUrlEncoded(request);
            }
        }
        if (!this.attributes.isEmpty()) {
            new ParamApplier(this.attributes){

                protected void applyParam(String paramName, String[] paramValues) {
                    request.requestAttr(paramName, (Object)paramValues[0]);
                }
            }.applyParams();
        }
        if (StringUtils.isNotBlank((CharSequence)requestContentType)) {
            request.contentType(MediaType.parseMediaType((String)requestContentType));
        }
        if (this.headers.exist()) {
            for (Header header : this.headers) {
                request.header(header.getName(), new Object[]{header.getValue()});
            }
        }
        if (this.cookies.exist()) {
            for (com.jayway.restassured.response.Cookie cookie : this.cookies) {
                Cookie servletCookie = new Cookie(cookie.getName(), cookie.getValue());
                if (cookie.hasComment()) {
                    servletCookie.setComment(cookie.getComment());
                }
                if (cookie.hasDomain()) {
                    servletCookie.setDomain(cookie.getDomain());
                }
                if (cookie.hasMaxAge()) {
                    servletCookie.setMaxAge(cookie.getMaxAge());
                }
                if (cookie.hasPath()) {
                    servletCookie.setPath(cookie.getPath());
                }
                if (cookie.hasVersion()) {
                    servletCookie.setVersion(cookie.getVersion());
                }
                request.cookie(new Cookie[]{servletCookie});
            }
        }
        if (!this.multiParts.isEmpty()) {
            MockMultipartHttpServletRequestBuilder multiPartRequest = (MockMultipartHttpServletRequestBuilder)request;
            for (MockMvcMultiPart multiPart : this.multiParts) {
                MockMultipartFile multipartFile;
                String fileName = multiPart.getFileName();
                String controlName = multiPart.getControlName();
                String mimeType = multiPart.getMimeType();
                if (multiPart.isByteArray()) {
                    multipartFile = new MockMultipartFile(controlName, fileName, mimeType, (byte[])multiPart.getContent());
                } else if (multiPart.isFile() || multiPart.isInputStream()) {
                    InputStream inputStream;
                    if (multiPart.isFile()) {
                        try {
                            inputStream = new FileInputStream((File)multiPart.getContent());
                        }
                        catch (FileNotFoundException e) {
                            return (MockMvcResponse)SafeExceptionRethrower.safeRethrow((Throwable)e);
                        }
                    } else {
                        inputStream = (InputStream)multiPart.getContent();
                    }
                    try {
                        multipartFile = new MockMultipartFile(controlName, fileName, mimeType, inputStream);
                    }
                    catch (IOException e) {
                        return (MockMvcResponse)SafeExceptionRethrower.safeRethrow((Throwable)e);
                    }
                } else {
                    multipartFile = new MockMultipartFile(controlName, fileName, mimeType, ((String)multiPart.getContent()).getBytes());
                }
                multiPartRequest.file(multipartFile);
            }
        }
        if (this.requestBody != null) {
            if (this.requestBody instanceof byte[]) {
                request.content((byte[])this.requestBody);
            } else if (this.requestBody instanceof File) {
                byte[] bytes = MockMvcRequestSenderImpl.toByteArray((File)this.requestBody);
                request.content(bytes);
            } else {
                request.content(this.requestBody.toString());
            }
        }
        this.logRequestIfApplicable(method, path);
        return this.performRequest(request);
    }

    private String findContentType() {
        EncoderConfig encoderConfig = this.config.getEncoderConfig();
        String requestContentType = this.headers.getValue(CONTENT_TYPE);
        if (requestContentType != null && encoderConfig.shouldAppendDefaultContentCharsetToContentTypeIfUndefined() && !StringUtils.containsIgnoreCase((CharSequence)requestContentType, (CharSequence)CHARSET)) {
            requestContentType = requestContentType + "; charset=" + encoderConfig.defaultContentCharset();
        }
        return requestContentType;
    }

    private static byte[] toByteArray(File file) {
        ByteArrayOutputStream ous = null;
        InputStream ios = null;
        try {
            byte[] buffer = new byte[4096];
            ous = new ByteArrayOutputStream();
            ios = new FileInputStream(file);
            int read = 0;
            while ((read = ios.read(buffer)) != -1) {
                ous.write(buffer, 0, read);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (ous != null) {
                    ous.close();
                }
                if (ios != null) {
                    ios.close();
                }
            }
            catch (IOException iOException) {}
        }
        return ous.toByteArray();
    }

    private void setContentTypeToApplicationFormUrlEncoded(MockHttpServletRequestBuilder request) {
        String contentType = "application/x-www-form-urlencoded";
        EncoderConfig encoderConfig = this.config.getEncoderConfig();
        if (encoderConfig.shouldAppendDefaultContentCharsetToContentTypeIfUndefined()) {
            contentType = contentType + "; charset=" + encoderConfig.defaultContentCharset();
        }
        MediaType mediaType = MediaType.parseMediaType((String)contentType);
        request.contentType(mediaType);
        ArrayList<Header> newHeaders = new ArrayList<Header>(this.headers.asList());
        newHeaders.add(new Header(CONTENT_TYPE, mediaType.toString()));
        this.headers = new Headers(newHeaders);
    }

    private boolean isInMultiPartMode(MockHttpServletRequestBuilder request) {
        return request instanceof MockMultipartHttpServletRequestBuilder;
    }

    private void logRequestIfApplicable(HttpMethod method, String path) {
        if (this.requestLoggingFilter == null) {
            return;
        }
        final RequestSpecificationImpl reqSpec = new RequestSpecificationImpl("", 8080, path, (AuthenticationScheme)new NoAuthScheme(), Collections.emptyList(), null, true, ConfigConverter.convertToRestAssuredConfig(this.config), this.logRepository, null);
        if (this.params != null) {
            new ParamLogger(this.params){

                protected void logParam(String paramName, Object paramValue) {
                    reqSpec.param(paramName, new Object[]{paramValue});
                }
            }.logParams();
        }
        if (this.queryParams != null) {
            new ParamLogger(this.queryParams){

                protected void logParam(String paramName, Object paramValue) {
                    reqSpec.queryParam(paramName, new Object[]{paramValue});
                }
            }.logParams();
        }
        if (this.formParams != null) {
            new ParamLogger(this.formParams){

                protected void logParam(String paramName, Object paramValue) {
                    reqSpec.formParam(paramName, new Object[]{paramValue});
                }
            }.logParams();
        }
        if (this.headers != null) {
            for (Header header : this.headers) {
                reqSpec.header(header);
            }
        }
        if (this.cookies != null) {
            for (com.jayway.restassured.response.Cookie cookie : this.cookies) {
                reqSpec.cookie(cookie);
            }
        }
        if (this.requestBody != null) {
            if (this.requestBody instanceof byte[]) {
                reqSpec.body((byte[])this.requestBody);
            } else if (this.requestBody instanceof File) {
                String contentType = this.findContentType();
                String charset = null;
                if (StringUtils.isNotBlank((CharSequence)contentType)) {
                    charset = CharsetExtractor.getCharsetFromContentType((String)contentType);
                }
                if (charset == null) {
                    charset = Charset.defaultCharset().toString();
                }
                String string = this.fileToString((File)this.requestBody, charset);
                reqSpec.body(string);
            } else {
                reqSpec.body(this.requestBody);
            }
        }
        if (this.multiParts != null) {
            for (MockMvcMultiPart multiPart : this.multiParts) {
                reqSpec.multiPart(new MultiPartSpecBuilder(multiPart.getContent()).controlName(multiPart.getControlName()).fileName(multiPart.getFileName()).mimeType(multiPart.getMimeType()).build());
            }
        }
        this.requestLoggingFilter.filter((FilterableRequestSpecification)reqSpec, null, (FilterContext)new FilterContextImpl(path, path, Method.valueOf((String)method.toString()), null, Collections.emptyList()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String fileToString(File file, String charset) {
        Scanner scanner;
        StringBuilder fileContents = new StringBuilder((int)file.length());
        try {
            scanner = new Scanner(file, charset);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        String lineSeparator = System.getProperty(LINE_SEPARATOR);
        try {
            while (scanner.hasNextLine()) {
                fileContents.append(scanner.nextLine()).append(lineSeparator);
            }
            String string = fileContents.toString();
            return string;
        }
        finally {
            scanner.close();
        }
    }

    public MockMvcResponse get(String path, Object ... pathParams) {
        return this.sendRequest(HttpMethod.GET, path, pathParams);
    }

    public MockMvcResponse get(String path, Map<String, ?> pathParams) {
        return this.get(path, this.mapToArray(pathParams));
    }

    public MockMvcResponse post(String path, Object ... pathParams) {
        return this.sendRequest(HttpMethod.POST, path, pathParams);
    }

    public MockMvcResponse post(String path, Map<String, ?> pathParams) {
        return this.post(path, this.mapToArray(pathParams));
    }

    public MockMvcResponse put(String path, Object ... pathParams) {
        return this.sendRequest(HttpMethod.PUT, path, pathParams);
    }

    public MockMvcResponse put(String path, Map<String, ?> pathParams) {
        return this.put(path, this.mapToArray(pathParams));
    }

    public MockMvcResponse delete(String path, Object ... pathParams) {
        return this.sendRequest(HttpMethod.DELETE, path, pathParams);
    }

    public MockMvcResponse delete(String path, Map<String, ?> pathParams) {
        return this.delete(path, this.mapToArray(pathParams));
    }

    public MockMvcResponse head(String path, Object ... pathParams) {
        return this.sendRequest(HttpMethod.HEAD, path, pathParams);
    }

    public MockMvcResponse head(String path, Map<String, ?> pathParams) {
        return this.head(path, this.mapToArray(pathParams));
    }

    public MockMvcResponse patch(String path, Object ... pathParams) {
        return this.sendRequest(HttpMethod.PATCH, path, pathParams);
    }

    public MockMvcResponse patch(String path, Map<String, ?> pathParams) {
        return this.patch(path, this.mapToArray(pathParams));
    }

    public MockMvcResponse options(String path, Object ... pathParams) {
        return this.sendRequest(HttpMethod.OPTIONS, path, pathParams);
    }

    public MockMvcResponse options(String path, Map<String, ?> pathParams) {
        return this.options(path, this.mapToArray(pathParams));
    }

    public MockMvcResponse get(URI uri) {
        return this.get(uri.toString(), new Object[0]);
    }

    public MockMvcResponse post(URI uri) {
        return this.post(uri.toString(), new Object[0]);
    }

    public MockMvcResponse put(URI uri) {
        return this.put(uri.toString(), new Object[0]);
    }

    public MockMvcResponse delete(URI uri) {
        return this.delete(uri.toString(), new Object[0]);
    }

    public MockMvcResponse head(URI uri) {
        return this.head(uri.toString(), new Object[0]);
    }

    public MockMvcResponse patch(URI uri) {
        return this.patch(uri.toString(), new Object[0]);
    }

    public MockMvcResponse options(URI uri) {
        return this.options(uri.toString(), new Object[0]);
    }

    public MockMvcResponse get(URL url) {
        return this.get(url.toString(), new Object[0]);
    }

    public MockMvcResponse post(URL url) {
        return this.post(url.toString(), new Object[0]);
    }

    public MockMvcResponse put(URL url) {
        return this.put(url.toString(), new Object[0]);
    }

    public MockMvcResponse delete(URL url) {
        return this.delete(url.toString(), new Object[0]);
    }

    public MockMvcResponse head(URL url) {
        return this.head(url.toString(), new Object[0]);
    }

    public MockMvcResponse patch(URL url) {
        return this.patch(url.toString(), new Object[0]);
    }

    public MockMvcResponse options(URL url) {
        return this.options(url.toString(), new Object[0]);
    }

    public MockMvcResponse get() {
        return this.get("", new Object[0]);
    }

    public MockMvcResponse post() {
        return this.post("", new Object[0]);
    }

    public MockMvcResponse put() {
        return this.put("", new Object[0]);
    }

    public MockMvcResponse delete() {
        return this.delete("", new Object[0]);
    }

    public MockMvcResponse head() {
        return this.head("", new Object[0]);
    }

    public MockMvcResponse patch() {
        return this.patch("", new Object[0]);
    }

    public MockMvcResponse options() {
        return this.options("", new Object[0]);
    }

    @Override
    public MockMvcRequestAsyncConfigurer with() {
        return this;
    }

    @Override
    public MockMvcRequestAsyncConfigurer and() {
        return this;
    }

    @Override
    public MockMvcRequestAsyncConfigurer timeout(long duration, TimeUnit timeUnit) {
        RestAssuredMockMvcConfig newConfig = this.config.asyncConfig(new AsyncConfig(duration, timeUnit));
        return new MockMvcRequestSenderImpl(this.mockMvc, this.params, this.queryParams, this.formParams, this.attributes, newConfig, this.requestBody, this.headers, this.cookies, this.multiParts, this.requestLoggingFilter, this.resultHandlers, this.requestPostProcessors, this.interceptor, this.basePath, this.responseSpecification, this.authentication, this.logRepository, this.isAsyncRequest);
    }

    @Override
    public MockMvcRequestAsyncConfigurer timeout(long durationInMs) {
        return this.timeout(durationInMs, TimeUnit.MILLISECONDS);
    }

    @Override
    public MockMvcRequestSender then() {
        return this;
    }

    @Override
    public MockMvcRequestAsyncConfigurer async() {
        return new MockMvcRequestSenderImpl(this.mockMvc, this.params, this.queryParams, this.formParams, this.attributes, this.config, this.requestBody, this.headers, this.cookies, this.multiParts, this.requestLoggingFilter, this.resultHandlers, this.requestPostProcessors, this.interceptor, this.basePath, this.responseSpecification, this.authentication, this.logRepository, true);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class ParamLogger {
        private Map<String, Object> map;

        protected ParamLogger(Map<String, Object> parameters) {
            this.map = parameters;
        }

        public void logParams() {
            for (Map.Entry<String, Object> stringListEntry : this.map.entrySet()) {
                ArrayList<Object> values;
                Object value = stringListEntry.getValue();
                if (value instanceof Collection) {
                    values = (ArrayList<Object>)value;
                } else {
                    values = new ArrayList<Object>();
                    values.add(value);
                }
                for (Object e : values) {
                    this.logParam(stringListEntry.getKey(), e);
                }
            }
        }

        protected abstract void logParam(String var1, Object var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class ParamApplier {
        private Map<String, Object> map;

        protected ParamApplier(Map<String, Object> parameters) {
            this.map = parameters;
        }

        public void applyParams() {
            for (Map.Entry<String, Object> listEntry : this.map.entrySet()) {
                String[] stringValues;
                Object value = listEntry.getValue();
                if (value instanceof Collection) {
                    Collection col = (Collection)value;
                    stringValues = new String[col.size()];
                    int index = 0;
                    for (Object val : col) {
                        stringValues[index] = val == null ? null : val.toString();
                        ++index;
                    }
                } else {
                    stringValues = new String[]{value == null ? null : value.toString()};
                }
                this.applyParam(listEntry.getKey(), stringValues);
            }
        }

        protected abstract void applyParam(String var1, String[] var2);
    }
}

