/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.restassured.module.mockmvc.specification;

import com.jayway.restassured.config.LogConfig;
import com.jayway.restassured.filter.log.LogDetail;
import com.jayway.restassured.filter.log.RequestLoggingFilter;
import com.jayway.restassured.http.ContentType;
import com.jayway.restassured.internal.assertion.AssertParameter;
import com.jayway.restassured.internal.mapper.ObjectMapperType;
import com.jayway.restassured.mapper.ObjectMapper;
import com.jayway.restassured.module.mockmvc.RestAssuredMockMvc;
import com.jayway.restassured.module.mockmvc.config.RestAssuredMockMvcConfig;
import com.jayway.restassured.module.mockmvc.intercept.MockHttpServletRequestBuilderInterceptor;
import com.jayway.restassured.module.mockmvc.internal.MockMvcRequestSpecificationImpl;
import com.jayway.restassured.module.mockmvc.specification.MockMvcAuthenticationScheme;
import com.jayway.restassured.module.mockmvc.specification.MockMvcRequestSpecification;
import com.jayway.restassured.response.Cookie;
import com.jayway.restassured.response.Header;
import java.io.File;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Map;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.ResultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockMvcRequestSpecBuilder {
    private MockMvcRequestSpecificationImpl spec = (MockMvcRequestSpecificationImpl)new MockMvcRequestSpecificationImpl(RestAssuredMockMvc.mockMvc, RestAssuredMockMvc.config, RestAssuredMockMvc.resultHandlers(), RestAssuredMockMvc.basePath, RestAssuredMockMvc.requestSpecification, RestAssuredMockMvc.responseSpecification, RestAssuredMockMvc.authentication).config(RestAssuredMockMvc.config);

    public MockMvcRequestSpecBuilder setAuth(MockMvcAuthenticationScheme auth) {
        auth.authenticate(this.spec);
        return this;
    }

    public MockMvcRequestSpecBuilder setBody(String body) {
        this.spec.body(body);
        return this;
    }

    public MockMvcRequestSpecBuilder setBody(byte[] body) {
        this.spec.body(body);
        return this;
    }

    public MockMvcRequestSpecBuilder setBody(Object object) {
        this.spec.body(object);
        return this;
    }

    public MockMvcRequestSpecBuilder setBody(Object object, ObjectMapper mapper) {
        this.spec.body(object, mapper);
        return this;
    }

    public MockMvcRequestSpecBuilder setBody(Object object, ObjectMapperType mapperType) {
        this.spec.body(object, mapperType);
        return this;
    }

    public MockMvcRequestSpecBuilder addCookies(Map<String, ?> cookies) {
        this.spec.cookies(cookies);
        return this;
    }

    public MockMvcRequestSpecBuilder addCookie(Cookie cookie) {
        this.spec.cookie(cookie);
        return this;
    }

    public MockMvcRequestSpecBuilder addCookie(String key, Object value, Object ... cookieNameValuePairs) {
        this.spec.cookie(key, value, cookieNameValuePairs);
        return this;
    }

    public MockMvcRequestSpecBuilder addParams(Map<String, ?> parametersMap) {
        this.spec.params(parametersMap);
        return this;
    }

    public MockMvcRequestSpecBuilder addParam(String parameterName, Object ... parameterValues) {
        this.spec.param(parameterName, parameterValues);
        return this;
    }

    public MockMvcRequestSpecBuilder addParam(String parameterName, Collection<?> parameterValues) {
        this.spec.param(parameterName, parameterValues);
        return this;
    }

    public MockMvcRequestSpecBuilder addQueryParam(String parameterName, Collection<?> parameterValues) {
        this.spec.queryParam(parameterName, parameterValues);
        return this;
    }

    public MockMvcRequestSpecBuilder addQueryParams(Map<String, ?> parametersMap) {
        this.spec.queryParams(parametersMap);
        return this;
    }

    public MockMvcRequestSpecBuilder addQueryParam(String parameterName, Object ... parameterValues) {
        this.spec.queryParam(parameterName, parameterValues);
        return this;
    }

    public MockMvcRequestSpecBuilder addFormParam(String parameterName, Collection<?> parameterValues) {
        this.spec.formParam(parameterName, parameterValues);
        return this;
    }

    public MockMvcRequestSpecBuilder addFormParams(Map<String, ?> parametersMap) {
        this.spec.formParams(parametersMap);
        return this;
    }

    public MockMvcRequestSpecBuilder addFormParam(String parameterName, Object ... parameterValues) {
        this.spec.formParam(parameterName, parameterValues);
        return this;
    }

    public MockMvcRequestSpecBuilder addAttribute(String attributeName, Object attributeValue) {
        this.spec.attribute(attributeName, attributeValue);
        return this;
    }

    public MockMvcRequestSpecBuilder addAttributes(Map<String, ?> attributesMap) {
        this.spec.attributes(attributesMap);
        return this;
    }

    public MockMvcRequestSpecBuilder addHeaders(Map<String, String> headers) {
        this.spec.headers(headers);
        return this;
    }

    public MockMvcRequestSpecBuilder addHeader(String headerName, String headerValue) {
        this.spec.header(headerName, headerValue, new Object[0]);
        return this;
    }

    public MockMvcRequestSpecBuilder addHeader(Header header) {
        this.spec.header(header);
        return this;
    }

    public MockMvcRequestSpecBuilder setContentType(ContentType contentType) {
        this.spec.contentType(contentType);
        return this;
    }

    public MockMvcRequestSpecBuilder setContentType(String contentType) {
        this.spec.contentType(contentType);
        return this;
    }

    public MockMvcRequestSpecBuilder addMultiPart(File file) {
        this.spec.multiPart(file);
        return this;
    }

    public MockMvcRequestSpecBuilder addMultiPart(String controlName, File file) {
        this.spec.multiPart(controlName, file);
        return this;
    }

    public MockMvcRequestSpecBuilder addMultiPart(String controlName, File file, String mimeType) {
        this.spec.multiPart(controlName, file, mimeType);
        return this;
    }

    public MockMvcRequestSpecBuilder addMultiPart(String controlName, String fileName, byte[] bytes) {
        this.spec.multiPart(controlName, fileName, bytes);
        return this;
    }

    public MockMvcRequestSpecBuilder addMultiPart(String controlName, String fileName, byte[] bytes, String mimeType) {
        this.spec.multiPart(controlName, fileName, bytes, mimeType);
        return this;
    }

    public MockMvcRequestSpecBuilder addMultiPart(String controlName, String fileName, InputStream stream) {
        this.spec.multiPart(controlName, fileName, stream);
        return this;
    }

    public MockMvcRequestSpecBuilder addMultiPart(String controlName, String fileName, InputStream stream, String mimeType) {
        this.spec.multiPart(controlName, fileName, stream, mimeType);
        return this;
    }

    public MockMvcRequestSpecBuilder addMultiPart(String controlName, String contentBody) {
        this.spec.multiPart(controlName, contentBody);
        return this;
    }

    public MockMvcRequestSpecBuilder addMultiPart(String controlName, String contentBody, String mimeType) {
        this.spec.multiPart(controlName, mimeType);
        return this;
    }

    public MockMvcRequestSpecBuilder setSessionId(String sessionIdValue) {
        this.spec.sessionId(sessionIdValue);
        return this;
    }

    public MockMvcRequestSpecBuilder setSessionId(String sessionIdName, String sessionIdValue) {
        this.spec.sessionId(sessionIdName, sessionIdValue);
        return this;
    }

    public MockMvcRequestSpecBuilder addMockMvcRequestSpecification(MockMvcRequestSpecification specification) {
        this.spec.spec(specification);
        return this;
    }

    public MockMvcRequestSpecBuilder setConfig(RestAssuredMockMvcConfig config) {
        this.spec.config(config);
        return this;
    }

    public MockMvcRequestSpecification build() {
        return this.spec;
    }

    public MockMvcRequestSpecBuilder setBasePath(String basePath) {
        this.spec.basePath(basePath);
        return this;
    }

    public MockMvcRequestSpecBuilder setMockMvc(MockMvc mockMvc) {
        this.spec.mockMvc(mockMvc);
        return this;
    }

    public MockMvcRequestSpecBuilder setMockHttpServletRequestBuilderInterceptor(MockHttpServletRequestBuilderInterceptor interceptor) {
        this.spec.interceptor(interceptor);
        return this;
    }

    public MockMvcRequestSpecBuilder addResultHandlers(ResultHandler resultHandler, ResultHandler ... additionalResultHandlers) {
        this.spec.resultHandlers(resultHandler, additionalResultHandlers);
        return this;
    }

    public MockMvcRequestSpecBuilder log(LogDetail logDetail) {
        AssertParameter.notNull((Object)logDetail, LogDetail.class);
        LogConfig logConfig = this.spec.getRestAssuredMockMvcConfig().getLogConfig();
        PrintStream printStream = logConfig.defaultStream();
        boolean prettyPrintingEnabled = logConfig.isPrettyPrintingEnabled();
        this.spec.setRequestLoggingFilter(new RequestLoggingFilter(logDetail, prettyPrintingEnabled, printStream));
        return this;
    }

    public MockMvcRequestSpecBuilder and() {
        return this;
    }
}

