/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.restassured.module.mockmvc.config;

import com.jayway.restassured.config.DecoderConfig;
import com.jayway.restassured.config.EncoderConfig;
import com.jayway.restassured.config.JsonConfig;
import com.jayway.restassured.config.LogConfig;
import com.jayway.restassured.config.ObjectMapperConfig;
import com.jayway.restassured.config.SessionConfig;
import com.jayway.restassured.config.XmlConfig;
import com.jayway.restassured.internal.assertion.AssertParameter;

public class RestAssuredMockMvcConfig {
    private final LogConfig logConfig;
    private final EncoderConfig encoderConfig;
    private final DecoderConfig decoderConfig;
    private final SessionConfig sessionConfig;
    private final ObjectMapperConfig objectMapperConfig;
    private final JsonConfig jsonConfig;
    private final XmlConfig xmlConfig;

    public RestAssuredMockMvcConfig() {
        this(new LogConfig(), new EncoderConfig(), new DecoderConfig(), new SessionConfig(), new ObjectMapperConfig(), new JsonConfig(), new XmlConfig());
    }

    public RestAssuredMockMvcConfig(LogConfig logConfig, EncoderConfig encoderConfig, DecoderConfig decoderConfig, SessionConfig sessionConfig, ObjectMapperConfig objectMapperConfig, JsonConfig jsonConfig, XmlConfig xmlConfig) {
        AssertParameter.notNull((Object)logConfig, (String)"Log config");
        AssertParameter.notNull((Object)encoderConfig, (String)"Encoder config");
        AssertParameter.notNull((Object)decoderConfig, (String)"Decoder config");
        AssertParameter.notNull((Object)sessionConfig, (String)"Session config");
        AssertParameter.notNull((Object)objectMapperConfig, (String)"Object mapper config");
        AssertParameter.notNull((Object)jsonConfig, (String)"Json config");
        AssertParameter.notNull((Object)xmlConfig, (String)"Xml config");
        this.logConfig = logConfig;
        this.encoderConfig = encoderConfig;
        this.decoderConfig = decoderConfig;
        this.sessionConfig = sessionConfig;
        this.objectMapperConfig = objectMapperConfig;
        this.jsonConfig = jsonConfig;
        this.xmlConfig = xmlConfig;
    }

    public RestAssuredMockMvcConfig logConfig(LogConfig logConfig) {
        AssertParameter.notNull((Object)logConfig, (String)"Log config");
        return new RestAssuredMockMvcConfig(logConfig, this.encoderConfig, this.decoderConfig, this.sessionConfig, this.objectMapperConfig, this.jsonConfig, this.xmlConfig);
    }

    public RestAssuredMockMvcConfig sessionConfig(SessionConfig sessionConfig) {
        AssertParameter.notNull((Object)sessionConfig, (String)"Session config");
        return new RestAssuredMockMvcConfig(this.logConfig, this.encoderConfig, this.decoderConfig, sessionConfig, this.objectMapperConfig, this.jsonConfig, this.xmlConfig);
    }

    public RestAssuredMockMvcConfig objectMapperConfig(ObjectMapperConfig objectMapperConfig) {
        AssertParameter.notNull((Object)objectMapperConfig, (String)"Object mapper config");
        return new RestAssuredMockMvcConfig(this.logConfig, this.encoderConfig, this.decoderConfig, this.sessionConfig, objectMapperConfig, this.jsonConfig, this.xmlConfig);
    }

    public RestAssuredMockMvcConfig jsonConfig(JsonConfig jsonConfig) {
        AssertParameter.notNull((Object)jsonConfig, (String)"JsonConfig");
        return new RestAssuredMockMvcConfig(this.logConfig, this.encoderConfig, this.decoderConfig, this.sessionConfig, this.objectMapperConfig, jsonConfig, this.xmlConfig);
    }

    public RestAssuredMockMvcConfig xmlConfig(XmlConfig xmlConfig) {
        AssertParameter.notNull((Object)xmlConfig, (String)"XmlConfig");
        return new RestAssuredMockMvcConfig(this.logConfig, this.encoderConfig, this.decoderConfig, this.sessionConfig, this.objectMapperConfig, this.jsonConfig, xmlConfig);
    }

    public RestAssuredMockMvcConfig and() {
        return this;
    }

    public RestAssuredMockMvcConfig set() {
        return this;
    }

    public RestAssuredMockMvcConfig with() {
        return this;
    }

    public LogConfig getLogConfig() {
        return this.logConfig;
    }

    public EncoderConfig getEncoderConfig() {
        return this.encoderConfig;
    }

    public DecoderConfig getDecoderConfig() {
        return this.decoderConfig;
    }

    public SessionConfig getSessionConfig() {
        return this.sessionConfig;
    }

    public ObjectMapperConfig getObjectMapperConfig() {
        return this.objectMapperConfig;
    }

    public JsonConfig getJsonConfig() {
        return this.jsonConfig;
    }

    public XmlConfig getXmlConfig() {
        return this.xmlConfig;
    }

    public static RestAssuredMockMvcConfig newConfig() {
        return new RestAssuredMockMvcConfig();
    }

    public static RestAssuredMockMvcConfig config() {
        return new RestAssuredMockMvcConfig();
    }
}

