/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.restassured.module.mockmvc.internal;

import com.jayway.restassured.internal.assertion.AssertParameter;
import java.io.File;
import java.io.InputStream;

class MockMvcMultiPart {
    private static final String OCTET_STREAM = "application/octet-stream";
    private static final String TEXT_PLAIN = "text/plain";
    private static final String DEFAULT_CONTROL_NAME = "file";
    private static final String DEFAULT_FILE_NAME = "file";
    private final String controlName;
    private final String fileName;
    private final Object content;
    private final String mimeType;

    MockMvcMultiPart(File file) {
        this("file", file);
    }

    MockMvcMultiPart(String controlName, File file) {
        this(controlName, file, OCTET_STREAM);
    }

    MockMvcMultiPart(String controlName, File file, String mimeType) {
        AssertParameter.notNull((Object)controlName, (String)"Control name");
        AssertParameter.notNull((Object)file, File.class);
        AssertParameter.notNull((Object)mimeType, (String)"Mime-Type");
        this.controlName = controlName;
        this.fileName = file.getName();
        this.content = file;
        this.mimeType = mimeType;
    }

    MockMvcMultiPart(String controlName, String content) {
        AssertParameter.notNull((Object)controlName, (String)"Control name");
        AssertParameter.notNull((Object)content, (String)"Content");
        this.controlName = controlName;
        this.fileName = "file";
        this.content = content;
        this.mimeType = TEXT_PLAIN;
    }

    MockMvcMultiPart(String controlName, String content, String mimeType) {
        AssertParameter.notNull((Object)controlName, (String)"Control name");
        AssertParameter.notNull((Object)mimeType, (String)"Mime-Type");
        AssertParameter.notNull((Object)content, (String)"Content");
        this.controlName = controlName;
        this.fileName = "file";
        this.content = content;
        this.mimeType = mimeType;
    }

    MockMvcMultiPart(String controlName, String fileName, Object content) {
        AssertParameter.notNull((Object)controlName, (String)"Control name");
        AssertParameter.notNull((Object)content, (String)"Content");
        this.controlName = controlName;
        this.fileName = fileName;
        this.content = content;
        this.mimeType = OCTET_STREAM;
    }

    MockMvcMultiPart(String controlName, String fileName, Object content, String mimeType) {
        AssertParameter.notNull((Object)mimeType, (String)"Mime-Type");
        AssertParameter.notNull((Object)content, (String)"Content");
        this.controlName = controlName;
        this.fileName = fileName;
        this.content = content;
        this.mimeType = mimeType;
    }

    public String getControlName() {
        return this.controlName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public Object getContent() {
        return this.content;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public boolean isInputStream() {
        return this.content instanceof InputStream;
    }

    public boolean isByteArray() {
        return this.content instanceof byte[];
    }

    public boolean isFile() {
        return this.content instanceof File;
    }

    public boolean isText() {
        return this.content instanceof String;
    }
}

