/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.restassured.builder;

import com.jayway.restassured.config.EncoderConfig;
import com.jayway.restassured.config.ObjectMapperConfig;
import com.jayway.restassured.internal.mapper.ObjectMapperType;
import com.jayway.restassured.internal.mapping.ObjectMapperSerializationContextImpl;
import com.jayway.restassured.internal.mapping.ObjectMapping;
import com.jayway.restassured.internal.multipart.MultiPartSpecificationImpl;
import com.jayway.restassured.mapper.ObjectMapper;
import com.jayway.restassured.specification.MultiPartSpecification;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.apache.commons.lang3.Validate;

public class MultiPartSpecBuilder {
    private final ObjectMapper explicitObjectMapper;
    private final ObjectMapperType explicitObjectMapperType;
    private Object content;
    private String controlName;
    private String mimeType;
    private String charset;
    private String fileName;
    private boolean isControlNameExplicit;
    private boolean isFileNameExplicit;

    public MultiPartSpecBuilder(Object content) {
        Validate.notNull((Object)content, (String)"Multi-part content cannot be null", (Object[])new Object[0]);
        this.content = content;
        this.controlName = "file";
        this.isControlNameExplicit = false;
        this.isFileNameExplicit = false;
        this.explicitObjectMapper = null;
        this.explicitObjectMapperType = null;
    }

    public MultiPartSpecBuilder(Object content, ObjectMapperType objectMapperType) {
        Validate.notNull((Object)content, (String)"Multi-part content cannot be null", (Object[])new Object[0]);
        Validate.notNull((Object)((Object)objectMapperType), (String)"Object mapper type cannot be null", (Object[])new Object[0]);
        this.explicitObjectMapperType = objectMapperType;
        this.explicitObjectMapper = null;
        this.content = content;
        this.controlName = "file";
        this.isControlNameExplicit = false;
        this.isFileNameExplicit = false;
    }

    public MultiPartSpecBuilder(Object content, ObjectMapper objectMapper) {
        Validate.notNull((Object)content, (String)"Multi-part content cannot be null", (Object[])new Object[0]);
        Validate.notNull((Object)objectMapper, (String)"Object mapper cannot be null", (Object[])new Object[0]);
        this.explicitObjectMapper = objectMapper;
        this.explicitObjectMapperType = null;
        this.content = content;
        this.controlName = "file";
        this.isControlNameExplicit = false;
        this.isFileNameExplicit = false;
    }

    public MultiPartSpecBuilder(InputStream content) {
        this((Object)content);
    }

    public MultiPartSpecBuilder(String content) {
        this((Object)content);
    }

    public MultiPartSpecBuilder(byte[] content) {
        this((Object)content);
    }

    public MultiPartSpecBuilder(File content) {
        this((Object)content);
    }

    public MultiPartSpecBuilder controlName(String controlName) {
        Validate.notEmpty((CharSequence)controlName, (String)"Control name cannot be empty", (Object[])new Object[0]);
        this.controlName = controlName;
        this.isControlNameExplicit = true;
        return this;
    }

    public MultiPartSpecBuilder fileName(String fileName) {
        this.fileName = fileName;
        this.isFileNameExplicit = true;
        return this;
    }

    public MultiPartSpecBuilder mimeType(String mimeType) {
        Validate.notEmpty((CharSequence)mimeType, (String)"Mime-type cannot be empty", (Object[])new Object[0]);
        this.mimeType = mimeType;
        return this;
    }

    public MultiPartSpecBuilder charset(String charset) {
        Validate.notEmpty((CharSequence)charset, (String)"Charset cannot be empty", (Object[])new Object[0]);
        if (this.content instanceof byte[] || this.content instanceof InputStream) {
            throw new IllegalArgumentException("Cannot specify charset input streams or byte arrays.");
        }
        this.charset = charset;
        return this;
    }

    public MultiPartSpecBuilder with() {
        return this;
    }

    public MultiPartSpecBuilder and() {
        return this;
    }

    public MultiPartSpecBuilder charset(Charset charset) {
        Validate.notNull((Object)charset, (String)"Charset cannot be null", (Object[])new Object[0]);
        this.charset = charset.toString();
        return this;
    }

    public MultiPartSpecBuilder emptyFileName() {
        return this.fileName(null);
    }

    public MultiPartSpecification build() {
        MultiPartSpecificationImpl spec = new MultiPartSpecificationImpl();
        spec.setCharset(this.charset);
        this.applyContentToSpec(spec);
        spec.setControlName(this.controlName);
        spec.setControlName(this.controlName);
        spec.setFileName(this.fileName);
        spec.setMimeType(this.mimeType);
        spec.setControlNameSpecifiedExplicitly(this.isControlNameExplicit);
        spec.setFileNameSpecifiedExplicitly(this.isFileNameExplicit);
        return spec;
    }

    private void applyContentToSpec(MultiPartSpecificationImpl spec) {
        Object actualContent;
        if (this.explicitObjectMapper != null) {
            ObjectMapperSerializationContextImpl ctx = new ObjectMapperSerializationContextImpl();
            ctx.setObject(this.content);
            ctx.setContentType(this.mimeType);
            actualContent = this.explicitObjectMapper.serialize(ctx);
        } else {
            actualContent = this.explicitObjectMapperType != null ? ObjectMapping.serialize(this.content, this.mimeType, null, this.explicitObjectMapperType, new ObjectMapperConfig(), new EncoderConfig()) : this.content;
        }
        spec.setContent(actualContent);
    }
}

